{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetLoad: Boolean;
    procedure SetLoad(const Value: Boolean);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "load". } { }
    property Load: Boolean read GetLoad write SetLoad;
    { Set X3D field "url". } { }
    procedure SetUrl(const Value: array of string);
    { Set X3D field "url". } { }
    procedure SetUrl(const Value: TCastleStringList);
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TInlineNode ----------------------------------------------- }

function TInlineNode.GetLoad: Boolean;
begin
  Result := FdLoad.Value;
end;

procedure TInlineNode.SetLoad(const Value: Boolean);
begin
  FdLoad.Send(Value);
end;

procedure TInlineNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TInlineNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

function TInlineNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TInlineNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
