{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
{$ifndef CASTLE_SLIM_NODES}
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
{$endif not CASTLE_SLIM_NODES}
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
  public
{$ifndef CASTLE_SLIM_NODES}
    { Set X3D field "attrib". } { }
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
{$endif not CASTLE_SLIM_NODES}
    { X3D field "color". } { }
    property Color: TAbstractColorNode read GetColor write SetColor;
    { X3D field "coord". } { }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
{$ifndef CASTLE_SLIM_NODES}
    { X3D field "fogCoord". } { }
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
{$endif not CASTLE_SLIM_NODES}
    { Set X3D field "colorIndex". } { }
    procedure SetColorIndex(const Value: array of LongInt);
    { Set X3D field "colorIndex". } { }
    procedure SetColorIndex(const Value: TLongIntList);
    { X3D field "colorPerVertex". } { }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: array of LongInt);
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: TLongIntList);

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedLineSetNode ----------------------------------------------- }

{$ifndef CASTLE_SLIM_NODES}
procedure TIndexedLineSetNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

{$endif not CASTLE_SLIM_NODES}
function TIndexedLineSetNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TIndexedLineSetNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
function TIndexedLineSetNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
procedure TIndexedLineSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedLineSetNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TIndexedLineSetNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

{$endif read_implementation}
