{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetConvex: Boolean;
    procedure SetConvex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
  public
    { Set X3D field "colorIndex". } { }
    procedure SetColorIndex(const Value: array of LongInt);
    { Set X3D field "colorIndex". } { }
    procedure SetColorIndex(const Value: TLongIntList);
    { X3D field "convex". } { }
    property Convex: Boolean read GetConvex write SetConvex;
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: array of LongInt);
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: TLongIntList);
    { X3D field "creaseAngle". } { }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;
    { Set X3D field "normalIndex". } { }
    procedure SetNormalIndex(const Value: array of LongInt);
    { Set X3D field "normalIndex". } { }
    procedure SetNormalIndex(const Value: TLongIntList);
    { Set X3D field "texCoordIndex". } { }
    procedure SetTexCoordIndex(const Value: array of LongInt);
    { Set X3D field "texCoordIndex". } { }
    procedure SetTexCoordIndex(const Value: TLongIntList);

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedFaceSetNode ----------------------------------------------- }

procedure TIndexedFaceSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetConvex: Boolean;
begin
  Result := FdConvex.Value;
end;

procedure TIndexedFaceSetNode.SetConvex(const Value: Boolean);
begin
  FdConvex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TIndexedFaceSetNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: array of LongInt);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: TLongIntList);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: array of LongInt);
begin
  FdTexCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: TLongIntList);
begin
  FdTexCoordIndex.Send(Value);
end;

{$endif read_implementation}
