{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3Double;
    procedure SetCenter(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetRange: Single;
    procedure SetRange(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "center". } { }
    property Center: TVector3Double read GetCenter write SetCenter;
    { Set X3D field "child1Url". } { }
    procedure SetChild1Url(const Value: array of string);
    { Set X3D field "child1Url". } { }
    procedure SetChild1Url(const Value: TCastleStringList);
    { Set X3D field "child2Url". } { }
    procedure SetChild2Url(const Value: array of string);
    { Set X3D field "child2Url". } { }
    procedure SetChild2Url(const Value: TCastleStringList);
    { Set X3D field "child3Url". } { }
    procedure SetChild3Url(const Value: array of string);
    { Set X3D field "child3Url". } { }
    procedure SetChild3Url(const Value: TCastleStringList);
    { Set X3D field "child4Url". } { }
    procedure SetChild4Url(const Value: array of string);
    { Set X3D field "child4Url". } { }
    procedure SetChild4Url(const Value: TCastleStringList);
    { X3D field "geoOrigin". } { }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: array of string);
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: TCastleStringList);
    { X3D field "range". } { }
    property Range: Single read GetRange write SetRange;
    { Set X3D field "rootUrl". } { }
    procedure SetRootUrl(const Value: array of string);
    { Set X3D field "rootUrl". } { }
    procedure SetRootUrl(const Value: TCastleStringList);
    { Set X3D field "rootNode". } { }
    procedure SetRootNode(const Value: array of TAbstractChildNode);
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoLODNode ----------------------------------------------- }

function TGeoLODNode.GetCenter: TVector3Double;
begin
  Result := FdCenter.Value;
end;

procedure TGeoLODNode.SetCenter(const Value: TVector3Double);
begin
  FdCenter.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: array of string);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: TCastleStringList);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: array of string);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: TCastleStringList);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: array of string);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: TCastleStringList);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: array of string);
begin
  FdChild4Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: TCastleStringList);
begin
  FdChild4Url.Send(Value);
end;

function TGeoLODNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoLODNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

function TGeoLODNode.GetRange: Single;
begin
  Result := FdRange.Value;
end;

procedure TGeoLODNode.SetRange(const Value: Single);
begin
  FdRange.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: array of string);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: TCastleStringList);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootNode(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdRootNode.Send(A);
end;

function TGeoLODNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TGeoLODNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
