/* This file is part of the KDE project
 * Copyright (C) 2008 Fredy Yanardi <fyanardi@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KOPAMASTERPAGEDIALOG_H
#define KOPAMASTERPAGEDIALOG_H

#include <KoDialog.h>

class QListView;

class KoPADocument;
class KoPAMasterPage;
class KoPAPageThumbnailModel;

class KoPAMasterPageDialog : public KoDialog
{
    Q_OBJECT
public:
    explicit KoPAMasterPageDialog(KoPADocument *document, KoPAMasterPage *activeMaster, QWidget *parent = 0);
    ~KoPAMasterPageDialog();

    KoPAMasterPage *selectedMasterPage();

private Q_SLOTS:
    void selectionChanged();

private:
    QListView *m_listView;
    KoPADocument *m_document;
    KoPAPageThumbnailModel *m_pageThumbnailModel;
};

#endif

