//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Plot2D/IntensityDataCanvas.h
//! @brief     Defines class IntensityDataCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATACANVAS_H
#define BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATACANVAS_H

#include "GUI/View/Common/DataAccessWidget.h"

class ColorMapCanvas;
class IntensityDataItem;
class QAction;

//! A color map that represents a IntensityDataItem, and provides standard actions
//! (reset view, save as) for external toolbars and context menus.

class IntensityDataCanvas : public DataAccessWidget {
public:
    explicit IntensityDataCanvas(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_Item) override;
    void setFourierItem(IntensityDataItem* fftItem) override;

    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

    QList<QAction*> actionList() override;

    void onResetViewAction();
    void onSavePlotAction();
    void onMousePress(QMouseEvent* event);

private:
    void initRotation();
    void rotateData();

    ColorMapCanvas* m_colorMapCanvas;
    QAction* m_resetViewAction;
    QAction* m_rotateDataAction;
    QAction* m_savePlotAction;
};

#endif // BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATACANVAS_H
