//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/IO/ReadWriteNumpyTXT.h
//! @brief     Declares functions read|writeNumpyTxt
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_DEVICE_IO_READWRITENUMPYTXT_H
#define BORNAGAIN_DEVICE_IO_READWRITENUMPYTXT_H

#include <istream>

class Datafield;

namespace Util::RW {

//! Reads Datafield from simple ASCII file with layout as in numpy.savetxt.
Datafield* readNumpyTxt(std::istream& input_stream);
//! Writes Datafield to simple ASCII file with layout as in numpy.savetxt.
void writeNumpyTxt(const Datafield& data, std::ostream& output_stream);

} // namespace Util::RW

#endif // BORNAGAIN_DEVICE_IO_READWRITENUMPYTXT_H
