/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.xpath.XPathException;

public class QueryProcessor {
    private StaticQueryContext staticContext;
    private Configuration config;

    public QueryProcessor(StaticQueryContext staticQueryContext) {
        this.config = staticQueryContext.getConfiguration();
        this.config.setHostLanguage(11);
        this.staticContext = staticQueryContext;
        staticQueryContext.setConfiguration(this.config);
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        AllElementStripper allElementStripper = null;
        if (this.config.isStripsAllWhiteSpace()) {
            allElementStripper = AllElementStripper.getInstance();
            allElementStripper.setStripAll();
        }
        NodeInfo nodeInfo = Builder.build(source, allElementStripper, this.config);
        return nodeInfo.getDocumentRoot();
    }

    public void setStaticContext(StaticQueryContext staticQueryContext) {
        this.staticContext = staticQueryContext;
    }

    public StaticQueryContext getStaticContext() {
        return this.staticContext;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XQueryExpression compileQuery(String string) throws XPathException {
        QueryParser queryParser = new QueryParser();
        Expression expression = queryParser.parseQuery(string, 0, 0, this.staticContext);
        XQueryExpression xQueryExpression = new XQueryExpression(expression, this.staticContext, this.config);
        return xQueryExpression;
    }

    public XQueryExpression compileQuery(Reader reader) throws XPathException, IOException {
        int n;
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer.toString());
    }
}

