/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:10:32 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.StringReader;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeaturePredicateConjunction;
import uk.ac.sanger.artemis.FeaturePredicateVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GCSDWindowAlgorithm_ESTest extends GCSDWindowAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      float[] floatArray0 = new float[7];
      floatArray0[0] = (float) 513;
      floatArray0[1] = (float) 843;
      floatArray0[2] = (float) 513;
      floatArray0[3] = (float) 513;
      floatArray0[5] = (float) 843;
      floatArray0[6] = (float) 513;
      StringReader stringReader0 = new StringReader("b_WV");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("'K", "'K");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getDefaultStepSize((-1676));
      gCSDWindowAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1358;
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 1358;
      floatArray0[4] = (float) 1358;
      floatArray0[5] = (float) (-1);
      floatArray0[6] = (float) 5;
      floatArray0[7] = (float) 5;
      floatArray0[8] = 0.0F;
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues((-1), 1358, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("G)", "G)");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.setUserMin((-5));
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues((-3462), 5000, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      uk.ac.sanger.artemis.Feature feature0 = null;
      try {
        feature0 = new uk.ac.sanger.artemis.Feature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Feature", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(" DZ]YGB");
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.getAverageGCPercent();
      bases0.getACount();
      Strand strand0 = bases0.getForwardStrand();
      emblStreamSequence0.copy();
      emblStreamSequence0.copy();
      Bases.reverseComplement("internal error - unexpected exception: ");
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getDefaultWindowSize();
      gCSDWindowAlgorithm0.setRevCompDisplay(true);
      gCSDWindowAlgorithm0.setUserMaxMin(true);
      gCSDWindowAlgorithm0.getMinimumInternal();
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      
      emblStreamSequence0.getSubSequence(1000, (-708));
      Range range0 = new Range(0);
      range0.copy();
      strand0.getRawSubSequence(range0);
      gCSDWindowAlgorithm0.getMaximumInternal();
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      
      gCSDWindowAlgorithm0.getMinimumInternal();
      gCSDWindowAlgorithm0.getMinimumInternal();
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertEquals(1000, (int)integer1);
      
      Float float1 = gCSDWindowAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float1, 0.01F);
      
      gCSDWindowAlgorithm0.getAverage();
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 5;
      gCSDWindowAlgorithm0.getValues(2, 520, floatArray0);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "ZJ<J,E}H&A");
      FeaturePredicateVector featurePredicateVector0 = new FeaturePredicateVector();
      FeaturePredicateConjunction featurePredicateConjunction0 = null;
      try {
        featurePredicateConjunction0 = new FeaturePredicateConjunction(featurePredicateVector0, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - no predicates given to FeaturePredicateConjunction constructor
         //
         verifyException("uk.ac.sanger.artemis.FeaturePredicateConjunction", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '(';
      charArray0[1] = '?';
      int int0 = 3893;
      Short short0 = new Short((short)0);
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 3893, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Short.toUnsignedInt((short)0);
      Strand strand0 = bases0.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getMinimum();
      gCSDWindowAlgorithm0.getMinimumInternal();
      gCSDWindowAlgorithm0.getValueCount();
      int int1 = 112;
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 5;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 1;
      Range range0 = null;
      // Undeclared exception!
      try { 
        bases0.getSubSequenceC((Range) null, (-3714));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[0] = 'c';
      charArray0[1] = 'u';
      charArray0[2] = '+';
      Short short0 = new Short((short) (-961));
      Integer integer0 = JLayeredPane.MODAL_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 100, 5, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 'u';
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 100;
      floatArray0[3] = (float) 'u';
      floatArray0[4] = (float) 'c';
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(16, 5, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = null;
      try {
        gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = ']';
      charArray0[1] = '';
      charArray0[2] = 'D';
      charArray0[3] = '2';
      charArray0[4] = '2';
      charArray0[5] = 'G';
      charArray0[6] = 'e';
      charArray0[7] = 't';
      charArray0[8] = 'c';
      Short short0 = new Short((short)0);
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-145), 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getDefaultMinWindowSize();
  }
}
