/*
 * Copyright (C) 2015 Robin Gareus <robin@gareus.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __libardouralsautil_deviceinfo_h__
#define __libardouralsautil_deviceinfo_h__

namespace ARDOUR {

	struct ALSADeviceInfo {
		unsigned int max_channels;
		unsigned int min_rate, max_rate;
		unsigned int min_nper, max_nper;
		unsigned long min_size, max_size;
		bool valid;
	};

	int get_alsa_device_parameters (const char* device_name, const bool play, ALSADeviceInfo *nfo);
}
#endif
