/***************************************************************************
                    SVGGenerator.h  -  description
                             -------------------
    begin                : Mo 23.06.2008
    copyright            : (C) 2019 by Andre Simon
    email                : a.simon@mailbox.org
 ***************************************************************************/


/*
This file is part of Highlight.

Highlight is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Highlight is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Highlight.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SVGGenerator_H
#define SVGGenerator_H

#include "codegenerator.h"

namespace ansifilter
{

/**
   \brief This class generates SVG.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class SVGGenerator : public ansifilter::CodeGenerator
{
public:

    SVGGenerator();
    ~SVGGenerator();

protected:

    string fileSuffix;   ///< filename extension

    /** \return Comment with program information */
    string getGeneratorComment();

    void insertLineNumber ();
    
    bool printDynamicStyleFile ( const string &outPath );


private:
    string getOpenTag();
    string getCloseTag();

    /** Print document header
    */
    string getHeader();

    /** Print document body*/
    void printBody();

    /** Print document footer*/
    string getFooter();

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );
    
};

}

#endif
