# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_firewall_policy
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_firewall_policy.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_firewall_policy_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'firewall_policy': {
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    expected_data = {
        'action': 'accept',
        'application-list': 'test_value_4',
        'auth-cert': 'test_value_5',
        'auth-path': 'enable',
        'auth-redirect-addr': 'test_value_7',
        'av-profile': 'test_value_8',
        'block-notification': 'enable',
        'captive-portal-exempt': 'enable',
        'capture-packet': 'enable',
        'comments': 'test_value_12',
        'delay-tcp-npu-session': 'enable',
        'diffserv-forward': 'enable',
        'diffserv-reverse': 'enable',
        'diffservcode-forward': 'test_value_16',
        'diffservcode-rev': 'test_value_17',
        'disclaimer': 'enable',
        'dlp-sensor': 'test_value_19',
        'dnsfilter-profile': 'test_value_20',
        'dscp-match': 'enable',
        'dscp-negate': 'enable',
        'dscp-value': 'test_value_23',
        'dsri': 'enable',
                'dstaddr-negate': 'enable',
                'firewall-session-dirty': 'check-all',
                'fixedport': 'enable',
                'fsso': 'enable',
                'fsso-agent-for-ntlm': 'test_value_29',
                'global-label': 'test_value_30',
                'icap-profile': 'test_value_31',
                'identity-based-route': 'test_value_32',
                'inbound': 'enable',
                'internet-service': 'enable',
                'internet-service-negate': 'enable',
                'internet-service-src': 'enable',
                'internet-service-src-negate': 'enable',
                'ippool': 'enable',
                'ips-sensor': 'test_value_39',
                'label': 'test_value_40',
                'learning-mode': 'enable',
                'logtraffic': 'all',
                'logtraffic-start': 'enable',
                'match-vip': 'enable',
                'name': 'default_name_45',
                'nat': 'enable',
                'natinbound': 'enable',
                'natip': 'test_value_48',
                'natoutbound': 'enable',
                'ntlm': 'enable',
                'ntlm-guest': 'enable',
                'outbound': 'enable',
                'per-ip-shaper': 'test_value_53',
                'permit-any-host': 'enable',
                'permit-stun-host': 'enable',
                'policyid': '56',
                'profile-group': 'test_value_57',
                'profile-protocol-options': 'test_value_58',
                'profile-type': 'single',
                'radius-mac-auth-bypass': 'enable',
                'redirect-url': 'test_value_61',
                'replacemsg-override-group': 'test_value_62',
                'rsso': 'enable',
                'rtp-nat': 'disable',
                'scan-botnet-connections': 'disable',
                'schedule': 'test_value_66',
                'schedule-timeout': 'enable',
                'send-deny-packet': 'disable',
                'service-negate': 'enable',
                'session-ttl': '70',
                'spamfilter-profile': 'test_value_71',
                'srcaddr-negate': 'enable',
                'ssh-filter-profile': 'test_value_73',
                'ssl-mirror': 'enable',
                'ssl-ssh-profile': 'test_value_75',
                'status': 'enable',
                'tcp-mss-receiver': '77',
                'tcp-mss-sender': '78',
                'tcp-session-without-syn': 'all',
                'timeout-send-rst': 'enable',
                'traffic-shaper': 'test_value_81',
                'traffic-shaper-reverse': 'test_value_82',
                'utm-status': 'enable',
                'uuid': 'test_value_84',
                'vlan-cos-fwd': '85',
                'vlan-cos-rev': '86',
                'vlan-filter': 'test_value_87',
                'voip-profile': 'test_value_88',
                'vpntunnel': 'test_value_89',
                'waf-profile': 'test_value_90',
                'wanopt': 'enable',
                'wanopt-detection': 'active',
                'wanopt-passive-opt': 'default',
                'wanopt-peer': 'test_value_94',
                'wanopt-profile': 'test_value_95',
                'wccp': 'enable',
                'webcache': 'enable',
                'webcache-https': 'disable',
                'webfilter-profile': 'test_value_99',
                'wsso': 'enable'
    }

    set_method_mock.assert_called_with('firewall', 'policy', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_firewall_policy_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'firewall_policy': {
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    expected_data = {
        'action': 'accept',
        'application-list': 'test_value_4',
        'auth-cert': 'test_value_5',
        'auth-path': 'enable',
        'auth-redirect-addr': 'test_value_7',
        'av-profile': 'test_value_8',
        'block-notification': 'enable',
        'captive-portal-exempt': 'enable',
        'capture-packet': 'enable',
        'comments': 'test_value_12',
        'delay-tcp-npu-session': 'enable',
        'diffserv-forward': 'enable',
        'diffserv-reverse': 'enable',
        'diffservcode-forward': 'test_value_16',
        'diffservcode-rev': 'test_value_17',
        'disclaimer': 'enable',
        'dlp-sensor': 'test_value_19',
        'dnsfilter-profile': 'test_value_20',
        'dscp-match': 'enable',
        'dscp-negate': 'enable',
        'dscp-value': 'test_value_23',
        'dsri': 'enable',
                'dstaddr-negate': 'enable',
                'firewall-session-dirty': 'check-all',
                'fixedport': 'enable',
                'fsso': 'enable',
                'fsso-agent-for-ntlm': 'test_value_29',
                'global-label': 'test_value_30',
                'icap-profile': 'test_value_31',
                'identity-based-route': 'test_value_32',
                'inbound': 'enable',
                'internet-service': 'enable',
                'internet-service-negate': 'enable',
                'internet-service-src': 'enable',
                'internet-service-src-negate': 'enable',
                'ippool': 'enable',
                'ips-sensor': 'test_value_39',
                'label': 'test_value_40',
                'learning-mode': 'enable',
                'logtraffic': 'all',
                'logtraffic-start': 'enable',
                'match-vip': 'enable',
                'name': 'default_name_45',
                'nat': 'enable',
                'natinbound': 'enable',
                'natip': 'test_value_48',
                'natoutbound': 'enable',
                'ntlm': 'enable',
                'ntlm-guest': 'enable',
                'outbound': 'enable',
                'per-ip-shaper': 'test_value_53',
                'permit-any-host': 'enable',
                'permit-stun-host': 'enable',
                'policyid': '56',
                'profile-group': 'test_value_57',
                'profile-protocol-options': 'test_value_58',
                'profile-type': 'single',
                'radius-mac-auth-bypass': 'enable',
                'redirect-url': 'test_value_61',
                'replacemsg-override-group': 'test_value_62',
                'rsso': 'enable',
                'rtp-nat': 'disable',
                'scan-botnet-connections': 'disable',
                'schedule': 'test_value_66',
                'schedule-timeout': 'enable',
                'send-deny-packet': 'disable',
                'service-negate': 'enable',
                'session-ttl': '70',
                'spamfilter-profile': 'test_value_71',
                'srcaddr-negate': 'enable',
                'ssh-filter-profile': 'test_value_73',
                'ssl-mirror': 'enable',
                'ssl-ssh-profile': 'test_value_75',
                'status': 'enable',
                'tcp-mss-receiver': '77',
                'tcp-mss-sender': '78',
                'tcp-session-without-syn': 'all',
                'timeout-send-rst': 'enable',
                'traffic-shaper': 'test_value_81',
                'traffic-shaper-reverse': 'test_value_82',
                'utm-status': 'enable',
                'uuid': 'test_value_84',
                'vlan-cos-fwd': '85',
                'vlan-cos-rev': '86',
                'vlan-filter': 'test_value_87',
                'voip-profile': 'test_value_88',
                'vpntunnel': 'test_value_89',
                'waf-profile': 'test_value_90',
                'wanopt': 'enable',
                'wanopt-detection': 'active',
                'wanopt-passive-opt': 'default',
                'wanopt-peer': 'test_value_94',
                'wanopt-profile': 'test_value_95',
                'wccp': 'enable',
                'webcache': 'enable',
                'webcache-https': 'disable',
                'webfilter-profile': 'test_value_99',
                'wsso': 'enable'
    }

    set_method_mock.assert_called_with('firewall', 'policy', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_firewall_policy_removal(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'firewall_policy': {
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    delete_method_mock.assert_called_with('firewall', 'policy', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_firewall_policy_deletion_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'firewall_policy': {
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    delete_method_mock.assert_called_with('firewall', 'policy', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_firewall_policy_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'firewall_policy': {
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    expected_data = {
        'action': 'accept',
        'application-list': 'test_value_4',
        'auth-cert': 'test_value_5',
        'auth-path': 'enable',
        'auth-redirect-addr': 'test_value_7',
        'av-profile': 'test_value_8',
        'block-notification': 'enable',
        'captive-portal-exempt': 'enable',
        'capture-packet': 'enable',
        'comments': 'test_value_12',
        'delay-tcp-npu-session': 'enable',
        'diffserv-forward': 'enable',
        'diffserv-reverse': 'enable',
        'diffservcode-forward': 'test_value_16',
        'diffservcode-rev': 'test_value_17',
        'disclaimer': 'enable',
        'dlp-sensor': 'test_value_19',
        'dnsfilter-profile': 'test_value_20',
        'dscp-match': 'enable',
        'dscp-negate': 'enable',
        'dscp-value': 'test_value_23',
        'dsri': 'enable',
                'dstaddr-negate': 'enable',
                'firewall-session-dirty': 'check-all',
                'fixedport': 'enable',
                'fsso': 'enable',
                'fsso-agent-for-ntlm': 'test_value_29',
                'global-label': 'test_value_30',
                'icap-profile': 'test_value_31',
                'identity-based-route': 'test_value_32',
                'inbound': 'enable',
                'internet-service': 'enable',
                'internet-service-negate': 'enable',
                'internet-service-src': 'enable',
                'internet-service-src-negate': 'enable',
                'ippool': 'enable',
                'ips-sensor': 'test_value_39',
                'label': 'test_value_40',
                'learning-mode': 'enable',
                'logtraffic': 'all',
                'logtraffic-start': 'enable',
                'match-vip': 'enable',
                'name': 'default_name_45',
                'nat': 'enable',
                'natinbound': 'enable',
                'natip': 'test_value_48',
                'natoutbound': 'enable',
                'ntlm': 'enable',
                'ntlm-guest': 'enable',
                'outbound': 'enable',
                'per-ip-shaper': 'test_value_53',
                'permit-any-host': 'enable',
                'permit-stun-host': 'enable',
                'policyid': '56',
                'profile-group': 'test_value_57',
                'profile-protocol-options': 'test_value_58',
                'profile-type': 'single',
                'radius-mac-auth-bypass': 'enable',
                'redirect-url': 'test_value_61',
                'replacemsg-override-group': 'test_value_62',
                'rsso': 'enable',
                'rtp-nat': 'disable',
                'scan-botnet-connections': 'disable',
                'schedule': 'test_value_66',
                'schedule-timeout': 'enable',
                'send-deny-packet': 'disable',
                'service-negate': 'enable',
                'session-ttl': '70',
                'spamfilter-profile': 'test_value_71',
                'srcaddr-negate': 'enable',
                'ssh-filter-profile': 'test_value_73',
                'ssl-mirror': 'enable',
                'ssl-ssh-profile': 'test_value_75',
                'status': 'enable',
                'tcp-mss-receiver': '77',
                'tcp-mss-sender': '78',
                'tcp-session-without-syn': 'all',
                'timeout-send-rst': 'enable',
                'traffic-shaper': 'test_value_81',
                'traffic-shaper-reverse': 'test_value_82',
                'utm-status': 'enable',
                'uuid': 'test_value_84',
                'vlan-cos-fwd': '85',
                'vlan-cos-rev': '86',
                'vlan-filter': 'test_value_87',
                'voip-profile': 'test_value_88',
                'vpntunnel': 'test_value_89',
                'waf-profile': 'test_value_90',
                'wanopt': 'enable',
                'wanopt-detection': 'active',
                'wanopt-passive-opt': 'default',
                'wanopt-peer': 'test_value_94',
                'wanopt-profile': 'test_value_95',
                'wccp': 'enable',
                'webcache': 'enable',
                'webcache-https': 'disable',
                'webfilter-profile': 'test_value_99',
                'wsso': 'enable'
    }

    set_method_mock.assert_called_with('firewall', 'policy', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_firewall_policy_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'firewall_policy': {
            'random_attribute_not_valid': 'tag',
            'action': 'accept',
            'application_list': 'test_value_4',
            'auth_cert': 'test_value_5',
            'auth_path': 'enable',
            'auth_redirect_addr': 'test_value_7',
            'av_profile': 'test_value_8',
            'block_notification': 'enable',
            'captive_portal_exempt': 'enable',
            'capture_packet': 'enable',
            'comments': 'test_value_12',
            'delay_tcp_npu_session': 'enable',
            'diffserv_forward': 'enable',
            'diffserv_reverse': 'enable',
            'diffservcode_forward': 'test_value_16',
            'diffservcode_rev': 'test_value_17',
            'disclaimer': 'enable',
            'dlp_sensor': 'test_value_19',
            'dnsfilter_profile': 'test_value_20',
            'dscp_match': 'enable',
            'dscp_negate': 'enable',
            'dscp_value': 'test_value_23',
            'dsri': 'enable',
            'dstaddr_negate': 'enable',
            'firewall_session_dirty': 'check-all',
            'fixedport': 'enable',
            'fsso': 'enable',
            'fsso_agent_for_ntlm': 'test_value_29',
            'global_label': 'test_value_30',
            'icap_profile': 'test_value_31',
            'identity_based_route': 'test_value_32',
            'inbound': 'enable',
            'internet_service': 'enable',
            'internet_service_negate': 'enable',
            'internet_service_src': 'enable',
            'internet_service_src_negate': 'enable',
            'ippool': 'enable',
            'ips_sensor': 'test_value_39',
            'label': 'test_value_40',
            'learning_mode': 'enable',
            'logtraffic': 'all',
            'logtraffic_start': 'enable',
            'match_vip': 'enable',
            'name': 'default_name_45',
            'nat': 'enable',
            'natinbound': 'enable',
            'natip': 'test_value_48',
            'natoutbound': 'enable',
            'ntlm': 'enable',
            'ntlm_guest': 'enable',
            'outbound': 'enable',
            'per_ip_shaper': 'test_value_53',
            'permit_any_host': 'enable',
            'permit_stun_host': 'enable',
            'policyid': '56',
            'profile_group': 'test_value_57',
            'profile_protocol_options': 'test_value_58',
            'profile_type': 'single',
            'radius_mac_auth_bypass': 'enable',
            'redirect_url': 'test_value_61',
            'replacemsg_override_group': 'test_value_62',
            'rsso': 'enable',
            'rtp_nat': 'disable',
            'scan_botnet_connections': 'disable',
            'schedule': 'test_value_66',
            'schedule_timeout': 'enable',
            'send_deny_packet': 'disable',
            'service_negate': 'enable',
            'session_ttl': '70',
            'spamfilter_profile': 'test_value_71',
            'srcaddr_negate': 'enable',
            'ssh_filter_profile': 'test_value_73',
            'ssl_mirror': 'enable',
            'ssl_ssh_profile': 'test_value_75',
            'status': 'enable',
            'tcp_mss_receiver': '77',
            'tcp_mss_sender': '78',
            'tcp_session_without_syn': 'all',
            'timeout_send_rst': 'enable',
            'traffic_shaper': 'test_value_81',
            'traffic_shaper_reverse': 'test_value_82',
            'utm_status': 'enable',
            'uuid': 'test_value_84',
            'vlan_cos_fwd': '85',
            'vlan_cos_rev': '86',
            'vlan_filter': 'test_value_87',
            'voip_profile': 'test_value_88',
            'vpntunnel': 'test_value_89',
            'waf_profile': 'test_value_90',
            'wanopt': 'enable',
            'wanopt_detection': 'active',
            'wanopt_passive_opt': 'default',
            'wanopt_peer': 'test_value_94',
            'wanopt_profile': 'test_value_95',
            'wccp': 'enable',
            'webcache': 'enable',
            'webcache_https': 'disable',
            'webfilter_profile': 'test_value_99',
            'wsso': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_firewall_policy.fortios_firewall(input_data, fos_instance)

    expected_data = {
        'action': 'accept',
        'application-list': 'test_value_4',
        'auth-cert': 'test_value_5',
        'auth-path': 'enable',
        'auth-redirect-addr': 'test_value_7',
        'av-profile': 'test_value_8',
        'block-notification': 'enable',
        'captive-portal-exempt': 'enable',
        'capture-packet': 'enable',
        'comments': 'test_value_12',
        'delay-tcp-npu-session': 'enable',
        'diffserv-forward': 'enable',
        'diffserv-reverse': 'enable',
        'diffservcode-forward': 'test_value_16',
        'diffservcode-rev': 'test_value_17',
        'disclaimer': 'enable',
        'dlp-sensor': 'test_value_19',
        'dnsfilter-profile': 'test_value_20',
        'dscp-match': 'enable',
        'dscp-negate': 'enable',
        'dscp-value': 'test_value_23',
        'dsri': 'enable',
                'dstaddr-negate': 'enable',
                'firewall-session-dirty': 'check-all',
                'fixedport': 'enable',
                'fsso': 'enable',
                'fsso-agent-for-ntlm': 'test_value_29',
                'global-label': 'test_value_30',
                'icap-profile': 'test_value_31',
                'identity-based-route': 'test_value_32',
                'inbound': 'enable',
                'internet-service': 'enable',
                'internet-service-negate': 'enable',
                'internet-service-src': 'enable',
                'internet-service-src-negate': 'enable',
                'ippool': 'enable',
                'ips-sensor': 'test_value_39',
                'label': 'test_value_40',
                'learning-mode': 'enable',
                'logtraffic': 'all',
                'logtraffic-start': 'enable',
                'match-vip': 'enable',
                'name': 'default_name_45',
                'nat': 'enable',
                'natinbound': 'enable',
                'natip': 'test_value_48',
                'natoutbound': 'enable',
                'ntlm': 'enable',
                'ntlm-guest': 'enable',
                'outbound': 'enable',
                'per-ip-shaper': 'test_value_53',
                'permit-any-host': 'enable',
                'permit-stun-host': 'enable',
                'policyid': '56',
                'profile-group': 'test_value_57',
                'profile-protocol-options': 'test_value_58',
                'profile-type': 'single',
                'radius-mac-auth-bypass': 'enable',
                'redirect-url': 'test_value_61',
                'replacemsg-override-group': 'test_value_62',
                'rsso': 'enable',
                'rtp-nat': 'disable',
                'scan-botnet-connections': 'disable',
                'schedule': 'test_value_66',
                'schedule-timeout': 'enable',
                'send-deny-packet': 'disable',
                'service-negate': 'enable',
                'session-ttl': '70',
                'spamfilter-profile': 'test_value_71',
                'srcaddr-negate': 'enable',
                'ssh-filter-profile': 'test_value_73',
                'ssl-mirror': 'enable',
                'ssl-ssh-profile': 'test_value_75',
                'status': 'enable',
                'tcp-mss-receiver': '77',
                'tcp-mss-sender': '78',
                'tcp-session-without-syn': 'all',
                'timeout-send-rst': 'enable',
                'traffic-shaper': 'test_value_81',
                'traffic-shaper-reverse': 'test_value_82',
                'utm-status': 'enable',
                'uuid': 'test_value_84',
                'vlan-cos-fwd': '85',
                'vlan-cos-rev': '86',
                'vlan-filter': 'test_value_87',
                'voip-profile': 'test_value_88',
                'vpntunnel': 'test_value_89',
                'waf-profile': 'test_value_90',
                'wanopt': 'enable',
                'wanopt-detection': 'active',
                'wanopt-passive-opt': 'default',
                'wanopt-peer': 'test_value_94',
                'wanopt-profile': 'test_value_95',
                'wccp': 'enable',
                'webcache': 'enable',
                'webcache-https': 'disable',
                'webfilter-profile': 'test_value_99',
                'wsso': 'enable'
    }

    set_method_mock.assert_called_with('firewall', 'policy', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
