; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -global-isel=0                    -mtriple=x86_64-apple-darwin10 | FileCheck %s --check-prefixes=X64,SDAG-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1     -mtriple=x86_64-apple-darwin10 | FileCheck %s --check-prefixes=X64,FASTISEL-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 | FileCheck %s --check-prefixes=GISEL-X64

define i32 @fcmp_oeq(float %x, float %y) {
; X64-LABEL: fcmp_oeq:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jne LBB0_1
; X64-NEXT:    jp LBB0_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB0_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oeq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    setnp %cl
; GISEL-X64-NEXT:    andb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB0_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB0_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oeq float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ogt(float %x, float %y) {
; X64-LABEL: fcmp_ogt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jbe LBB1_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB1_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ogt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB1_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB1_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ogt float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_oge(float %x, float %y) {
; X64-LABEL: fcmp_oge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jb LBB2_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB2_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB2_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB2_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oge float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_olt(float %x, float %y) {
; X64-LABEL: fcmp_olt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jbe LBB3_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB3_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_olt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB3_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB3_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp olt float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ole(float %x, float %y) {
; X64-LABEL: fcmp_ole:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jb LBB4_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB4_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ole:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB4_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB4_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ole float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_one(float %x, float %y) {
; X64-LABEL: fcmp_one:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    je LBB5_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB5_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_one:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB5_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB5_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp one float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ord(float %x, float %y) {
; X64-LABEL: fcmp_ord:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jp LBB6_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB6_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ord:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB6_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB6_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ord float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uno(float %x, float %y) {
; X64-LABEL: fcmp_uno:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jp LBB7_2
; X64-NEXT:  ## %bb.1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB7_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uno:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB7_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB7_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uno float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ueq(float %x, float %y) {
; X64-LABEL: fcmp_ueq:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    je LBB8_2
; X64-NEXT:  ## %bb.1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB8_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ueq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB8_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB8_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ueq float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ugt(float %x, float %y) {
; X64-LABEL: fcmp_ugt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jae LBB9_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB9_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB9_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB9_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ugt float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uge(float %x, float %y) {
; X64-LABEL: fcmp_uge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    ja LBB10_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB10_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB10_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB10_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uge float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ult(float %x, float %y) {
; X64-LABEL: fcmp_ult:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jae LBB11_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB11_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB11_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB11_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ult float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ule(float %x, float %y) {
; X64-LABEL: fcmp_ule:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    ja LBB12_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB12_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB12_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB12_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ule float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_une(float %x, float %y) {
; X64-LABEL: fcmp_une:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jne LBB13_2
; X64-NEXT:    jnp LBB13_1
; X64-NEXT:  LBB13_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB13_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_une:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    setp %cl
; GISEL-X64-NEXT:    orb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB13_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB13_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp une float %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_oeq1(float %x) {
; X64-LABEL: fcmp_oeq1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB14_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB14_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oeq1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    setnp %cl
; GISEL-X64-NEXT:    andb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB14_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB14_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oeq float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_oeq2(float %x) {
; X64-LABEL: fcmp_oeq2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jne LBB15_1
; X64-NEXT:    jp LBB15_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB15_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oeq2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    setnp %cl
; GISEL-X64-NEXT:    andb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB15_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB15_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oeq float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ogt1(float %x) {
; SDAG-X64-LABEL: fcmp_ogt1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    je LBB16_1
; SDAG-X64-NEXT:  ## %bb.2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB16_1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_ogt1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    movl $1, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ogt1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB16_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB16_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ogt float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ogt2(float %x) {
; X64-LABEL: fcmp_ogt2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jbe LBB17_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB17_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ogt2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB17_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB17_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ogt float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_oge1(float %x) {
; X64-LABEL: fcmp_oge1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB18_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB18_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oge1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB18_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB18_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oge float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_oge2(float %x) {
; X64-LABEL: fcmp_oge2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jb LBB19_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB19_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_oge2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB19_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB19_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp oge float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_olt1(float %x) {
; SDAG-X64-LABEL: fcmp_olt1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    je LBB20_1
; SDAG-X64-NEXT:  ## %bb.2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB20_1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_olt1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    movl $1, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_olt1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB20_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB20_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp olt float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_olt2(float %x) {
; X64-LABEL: fcmp_olt2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jbe LBB21_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB21_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_olt2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB21_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB21_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp olt float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ole1(float %x) {
; X64-LABEL: fcmp_ole1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB22_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB22_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ole1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB22_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB22_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ole float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ole2(float %x) {
; X64-LABEL: fcmp_ole2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jb LBB23_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB23_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ole2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB23_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB23_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ole float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_one1(float %x) {
; SDAG-X64-LABEL: fcmp_one1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    je LBB24_1
; SDAG-X64-NEXT:  ## %bb.2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB24_1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_one1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    movl $1, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_one1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB24_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB24_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp one float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_one2(float %x) {
; X64-LABEL: fcmp_one2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    je LBB25_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB25_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_one2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB25_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB25_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp one float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ord1(float %x) {
; X64-LABEL: fcmp_ord1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB26_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB26_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ord1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB26_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB26_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ord float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ord2(float %x) {
; X64-LABEL: fcmp_ord2:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB27_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB27_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ord2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB27_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB27_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ord float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uno1(float %x) {
; X64-LABEL: fcmp_uno1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB28_2
; X64-NEXT:  ## %bb.1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB28_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uno1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB28_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB28_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uno float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uno2(float %x) {
; X64-LABEL: fcmp_uno2:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jp LBB29_2
; X64-NEXT:  ## %bb.1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB29_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uno2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB29_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB29_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uno float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ueq1(float %x) {
; SDAG-X64-LABEL: fcmp_ueq1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movb $1, %al
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    jne LBB30_2
; SDAG-X64-NEXT:  ## %bb.1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB30_2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_ueq1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    xorl %eax, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ueq1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB30_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB30_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ueq float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ueq2(float %x) {
; X64-LABEL: fcmp_ueq2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    je LBB31_2
; X64-NEXT:  ## %bb.1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB31_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ueq2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    jne LBB31_2
; GISEL-X64-NEXT:  ## %bb.1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB31_2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ueq float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ugt1(float %x) {
; X64-LABEL: fcmp_ugt1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jnp LBB32_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB32_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ugt1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB32_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB32_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ugt float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ugt2(float %x) {
; X64-LABEL: fcmp_ugt2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    jae LBB33_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB33_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ugt2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB33_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB33_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ugt float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uge1(float %x) {
; SDAG-X64-LABEL: fcmp_uge1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movb $1, %al
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    je LBB34_1
; SDAG-X64-NEXT:  ## %bb.2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB34_1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_uge1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    xorl %eax, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uge1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB34_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB34_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uge float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_uge2(float %x) {
; X64-LABEL: fcmp_uge2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    ja LBB35_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB35_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_uge2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB35_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB35_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp uge float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ult1(float %x) {
; X64-LABEL: fcmp_ult1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jnp LBB36_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB36_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ult1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB36_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB36_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ult float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ult2(float %x) {
; X64-LABEL: fcmp_ult2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jae LBB37_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB37_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ult2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB37_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB37_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ult float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ule1(float %x) {
; SDAG-X64-LABEL: fcmp_ule1:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    movb $1, %al
; SDAG-X64-NEXT:    testb %al, %al
; SDAG-X64-NEXT:    je LBB38_1
; SDAG-X64-NEXT:  ## %bb.2: ## %bb1
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    retq
; SDAG-X64-NEXT:  LBB38_1: ## %bb2
; SDAG-X64-NEXT:    movl $1, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: fcmp_ule1:
; FASTISEL-X64:       ## %bb.0:
; FASTISEL-X64-NEXT:    xorl %eax, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ule1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB38_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB38_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ule float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_ule2(float %x) {
; X64-LABEL: fcmp_ule2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    ja LBB39_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB39_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_ule2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB39_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB39_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp ule float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_une1(float %x) {
; X64-LABEL: fcmp_une1:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    jnp LBB40_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB40_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_une1:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    setp %cl
; GISEL-X64-NEXT:    orb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB40_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB40_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp une float %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @fcmp_une2(float %x) {
; X64-LABEL: fcmp_une2:
; X64:       ## %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    jne LBB41_2
; X64-NEXT:    jnp LBB41_1
; X64-NEXT:  LBB41_2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB41_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_une2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [0.0E+0,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    setp %cl
; GISEL-X64-NEXT:    orb %al, %cl
; GISEL-X64-NEXT:    testb $1, %cl
; GISEL-X64-NEXT:    je LBB41_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB41_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
  %1 = fcmp une float %x, 0.000000e+00
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}
