/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import com.apple.eio.FileManager;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.UIManager;
import processing.app.Base;
import processing.app.macosx.ThinkDifferent;
import processing.core.PApplet;

public class Platform
extends processing.app.Platform {
    static final int kDocumentsFolderType = 1685021555;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;

    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
        UIManager.put("Component.visualMargin", new Insets(1, 1, 1, 1));
    }

    public void init(Base base) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ThinkDifferent.init(base);
    }

    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Arduino");
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Arduino");
    }

    public void openURL(String string) throws Exception {
        if (PApplet.javaVersion < 1.6f) {
            if (string.startsWith("http://")) {
                try {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getMethod("openURL", String.class);
                    method.invoke(null, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                PApplet.open((String)string);
            }
        } else {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("getDesktop", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (string.startsWith("http://")) {
                    Method method2 = clazz.getMethod("browse", URI.class);
                    method2.invoke(object, new URI(string));
                } else {
                    Method method3 = clazz.getMethod("open", File.class);
                    method3.invoke(object, new File(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean openFolderAvailable() {
        return true;
    }

    public void openFolder(File file) throws Exception {
        PApplet.open((String)file.getAbsolutePath());
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }
}

