/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Theme;

public class EditorToolbar
extends JComponent
implements MouseInputListener,
KeyListener {
    static final String[] title = new String[]{"Verify", "Stop", "New", "Open", "Save", "Upload", "Serial Monitor"};
    static final String[] titleShift = new String[]{"Verify (w/ Verbose Output)", "Stop", "New Editor Window", "Open in Another Window", "Save", "Upload (w/ Verbose Output)", "Serial Monitor"};
    static final int BUTTON_COUNT = title.length;
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final int BUTTON_GAP = 5;
    static final int BUTTON_IMAGE_SIZE = 33;
    static final int RUN = 0;
    static final int STOP = 1;
    static final int NEW = 2;
    static final int OPEN = 3;
    static final int SAVE = 4;
    static final int EXPORT = 5;
    static final int SERIAL = 6;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    Editor editor;
    Image offscreen;
    int width;
    int height;
    Color bgcolor;
    static Image[][] buttonImages;
    int currentRollover;
    JPopupMenu popup;
    JMenu menu;
    int buttonCount;
    int[] state = new int[BUTTON_COUNT];
    Image[] stateImage;
    int[] which;
    int[] x1;
    int[] x2;
    int y1;
    int y2;
    Font statusFont;
    Color statusColor;
    boolean shiftPressed;
    int wasDown = -1;

    public EditorToolbar(Editor editor, JMenu jMenu) {
        this.editor = editor;
        this.menu = jMenu;
        this.buttonCount = 0;
        this.which = new int[BUTTON_COUNT];
        this.which[this.buttonCount++] = 0;
        this.which[this.buttonCount++] = 1;
        this.which[this.buttonCount++] = 2;
        this.which[this.buttonCount++] = 3;
        this.which[this.buttonCount++] = 4;
        this.which[this.buttonCount++] = 5;
        this.which[this.buttonCount++] = 6;
        this.currentRollover = -1;
        this.bgcolor = Theme.getColor("buttons.bgcolor");
        this.statusFont = Theme.getFont("buttons.status.font");
        this.statusColor = Theme.getColor("buttons.status.color");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void loadButtons() {
        Image image = Base.getThemeImage("buttons.gif", this);
        buttonImages = new Image[BUTTON_COUNT][3];
        for (int i = 0; i < BUTTON_COUNT; ++i) {
            for (int j = 0; j < 3; ++j) {
                Image image2 = this.createImage(27, 32);
                Graphics graphics = image2.getGraphics();
                graphics.drawImage(image, -(i * 33) - 3, (-2 + j) * 33, null);
                EditorToolbar.buttonImages[i][j] = image2;
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (buttonImages == null) {
            this.loadButtons();
        }
        if (this.stateImage == null) {
            this.state = new int[this.buttonCount];
            this.stateImage = new Image[this.buttonCount];
            for (int i = 0; i < this.buttonCount; ++i) {
                this.setState(i, 0, false);
            }
            this.y1 = 0;
            this.y2 = 32;
            this.x1 = new int[this.buttonCount];
            this.x2 = new int[this.buttonCount];
        }
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.width || dimension.height != this.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.width = dimension.width;
            this.height = dimension.height;
            int n2 = 3;
            for (n = 0; n < this.buttonCount; ++n) {
                this.x1[n] = n2;
                if (n == 2 || n == 6) {
                    int n3 = n;
                    this.x1[n3] = this.x1[n3] + 5;
                }
                this.x2[n] = this.x1[n] + 27;
                n2 = this.x2[n];
            }
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(this.bgcolor);
        graphics2.fillRect(0, 0, this.width, this.height);
        for (n = 0; n < this.buttonCount; ++n) {
            graphics2.drawImage(this.stateImage[n], this.x1[n], this.y1, null);
        }
        graphics2.setColor(this.statusColor);
        graphics2.setFont(this.statusFont);
        if (this.currentRollover != -1) {
            n = (32 + graphics2.getFontMetrics().getAscent()) / 2;
            String string = this.shiftPressed ? titleShift[this.currentRollover] : title[this.currentRollover];
            graphics2.drawString(string, this.buttonCount * 27 + 15, n);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
        if (!this.isEnabled()) {
            graphics.setColor(new Color(0, 0, 0, 100));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.state == null) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, false);
        }
        this.handleMouse(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void handleMouse(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.currentRollover != -1) {
            if (n2 > this.x1[this.currentRollover] && n3 > this.y1 && n2 < this.x2[this.currentRollover] && n3 < this.y2) {
                return;
            }
            this.setState(this.currentRollover, 0, true);
            this.currentRollover = -1;
        }
        if ((n = this.findSelection(n2, n3)) == -1) {
            return;
        }
        if (this.state[n] != 2) {
            this.setState(n, 1, true);
            this.currentRollover = n;
        }
    }

    private int findSelection(int n, int n2) {
        if (this.x1 == null || this.x2 == null) {
            return -1;
        }
        for (int i = 0; i < this.buttonCount; ++i) {
            if (n2 <= this.y1 || n <= this.x1[i] || n2 >= this.y2 || n >= this.x2[i]) continue;
            return i;
        }
        return -1;
    }

    private void setState(int n, int n2, boolean bl) {
        this.state[n] = n2;
        this.stateImage[n] = buttonImages[this.which[n]][n2];
        if (bl) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, true);
        }
        this.handleMouse(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = this.findSelection(n2, n = mouseEvent.getY());
        if (n3 == -1) {
            return;
        }
        this.currentRollover = -1;
        switch (n3) {
            case 0: {
                this.editor.handleRun(mouseEvent.isShiftDown());
                break;
            }
            case 1: {
                this.editor.handleStop();
                break;
            }
            case 3: {
                this.popup = this.menu.getPopupMenu();
                this.popup.show(this, n2, n);
                break;
            }
            case 2: {
                if (this.shiftPressed) {
                    this.editor.base.handleNew();
                    break;
                }
                this.editor.base.handleNewReplace();
                break;
            }
            case 4: {
                this.editor.handleSave(false);
                break;
            }
            case 5: {
                this.editor.handleExport(mouseEvent.isShiftDown());
                break;
            }
            case 6: {
                this.editor.handleSerial();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void activate(int n) {
        if (buttonImages != null) {
            this.setState(n, 2, true);
        }
    }

    public void deactivate(int n) {
        if (buttonImages != null) {
            this.setState(n, 0, true);
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension((BUTTON_COUNT + 1) * 27, 32);
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.shiftPressed = true;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.shiftPressed = false;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

