/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.VisuallyLayoutableIcon;
import ch.randelshofer.quaqua.icon.ButtonFocusIcon;
import ch.randelshofer.quaqua.icon.ButtonStateIcon;
import ch.randelshofer.quaqua.icon.FrameButtonStateIcon;
import ch.randelshofer.quaqua.icon.OverlayIcon;
import ch.randelshofer.quaqua.icon.ShiftedIcon;
import ch.randelshofer.quaqua.icon.SliderThumbIcon;
import ch.randelshofer.quaqua.osx.OSXApplication;
import ch.randelshofer.quaqua.osx.OSXImageIO;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.SwingWorker;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;

public class QuaquaIconFactory {
    private static BufferedImage applicationImage64;
    private static BufferedImage applicationImage32;

    private QuaquaIconFactory() {
    }

    public static URL getResource(String location) {
        URL url = QuaquaIconFactory.class.getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    public static Image createImage(String location) {
        return Images.createImage(QuaquaIconFactory.class, location);
    }

    public static Image createImage(Class baseClass, String location) {
        return Images.createImage(baseClass, location);
    }

    public static Image createBufferedImage(String location) {
        return Images.toBufferedImage(QuaquaIconFactory.createImage(location));
    }

    public static Icon[] createIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    public static Icon createIcon(String location, int count, boolean horizontal, int index) {
        return QuaquaIconFactory.createIcons(location, count, horizontal)[index];
    }

    public static Icon createButtonStateIcon(String location, int states) {
        return new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createButtonStateIcon(String location, int states, Point shift) {
        return new ShiftedIcon((Icon)new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true), shift);
    }

    public static Icon createButtonStateIcon(String location, int states, Rectangle shift) {
        return new ShiftedIcon((Icon)new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true), shift);
    }

    public static Icon createFrameButtonStateIcon(String location, int states) {
        return new FrameButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createOverlaidButtonStateIcon(String location1, int states1, String location2, int states2, Rectangle layoutRect) {
        return new IconUIResource(new VisuallyLayoutableIcon(new OverlayIcon(QuaquaIconFactory.createButtonStateIcon(location1, states1), QuaquaIconFactory.createButtonFocusIcon(location2, states2)), layoutRect));
    }

    public static Icon createButtonFocusIcon(String location, int states) {
        return new ButtonFocusIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createSliderThumbIcon(String location) {
        return new SliderThumbIcon(QuaquaIconFactory.createImage(location), 6, true);
    }

    public static Icon createIcon(Class baseClass, String location) {
        return new ImageIcon(QuaquaIconFactory.createImage(baseClass, location));
    }

    public static Icon createIcon(Class baseClass, String location, Point shift) {
        return new ShiftedIcon((Icon)new ImageIcon(QuaquaIconFactory.createImage(baseClass, location)), shift);
    }

    public static Icon createIcon(Class baseClass, String location, Rectangle shiftAndSize) {
        return new ShiftedIcon((Icon)new ImageIcon(QuaquaIconFactory.createImage(baseClass, location)), shiftAndSize);
    }

    public static Icon createNativeIcon(String path, int size) {
        try {
            BufferedImage img = OSXImageIO.read(new File(path), size, size);
            if (img == null) {
                return null;
            }
            return new ImageIcon(img);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static Icon createNativeIcon(String path, int width, int height) {
        try {
            BufferedImage img = OSXImageIO.read(new File(path), width, height);
            if (img == null) {
                return null;
            }
            return new ImageIcon(img);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static Icon createOptionPaneIcon(int messageType) {
        return new LazyOptionPaneIcon(messageType);
    }

    private static ImageIcon createApplicationIcon() {
        return new ImageIcon(QuaquaIconFactory.getApplicationIconImage());
    }

    private static ImageIcon createWarningIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon(UIManager.getString("OptionPane.warningIconResource"));
    }

    private static ImageIcon createErrorIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon(UIManager.getString("OptionPane.errorIconResource"));
    }

    private static ImageIcon composeOptionPaneIcon(String resource) {
        BufferedImage result = new BufferedImage(64, 64, 2);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        BufferedImage warningImage = Images.toBufferedImage(Images.createImage(QuaquaIconFactory.class.getResource(resource)));
        g.drawImage(warningImage, 0, 0, 58, 58, null);
        BufferedImage appImage = OSXApplication.getIconImage(32);
        g.drawImage(appImage, 32, 32, 32, 32, null);
        g.dispose();
        return new ImageIcon(result);
    }

    public static BufferedImage getApplicationIconImage() {
        if (applicationImage64 == null) {
            applicationImage64 = OSXApplication.getIconImage(64);
        }
        return applicationImage64;
    }

    private static class LazyOptionPaneIcon
    implements Icon {
        private ImageIcon realIcon;
        private int messageType;
        private SwingWorker worker;
        private HashSet repaintMe = new HashSet();

        public LazyOptionPaneIcon(final int messageType) {
            this.messageType = messageType;
            this.worker = new SwingWorker(){

                public Object construct() {
                    try {
                        switch (messageType) {
                            case 2: {
                                return QuaquaIconFactory.createWarningIcon();
                            }
                            case 0: {
                                return QuaquaIconFactory.createErrorIcon();
                            }
                        }
                        return QuaquaIconFactory.createApplicationIcon();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        return null;
                    }
                }

                public void finished() {
                    LazyOptionPaneIcon.this.realIcon = (ImageIcon)this.get();
                    Iterator i = LazyOptionPaneIcon.this.repaintMe.iterator();
                    while (i.hasNext()) {
                        Component c = (Component)i.next();
                        c.repaint();
                    }
                    LazyOptionPaneIcon.this.repaintMe = null;
                    LazyOptionPaneIcon.this.worker = null;
                }
            };
            this.worker.start();
        }

        public int getIconHeight() {
            return 64;
        }

        public int getIconWidth() {
            return 64;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.realIcon == null && this.worker != null) {
                this.repaintMe.add(c);
            }
            if (this.realIcon != null) {
                this.realIcon.paintIcon(c, g, x, y);
            }
        }
    }
}

