/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContactList;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.RecordRouteHeader;
import sip4me.gov.nist.siplite.header.RecordRouteList;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.RouteList;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPTransactionStack;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.gov.nist.siplite.stack.Transaction;

public class Dialog {
    private Object applicationData;
    private Transaction firstTransaction;
    private Transaction lastTransaction;
    private String dialogId;
    private int localSequenceNumber = 0;
    private int remoteSequenceNumber = -1;
    private String myTag;
    private String hisTag;
    private RouteList routeList = new RouteList();
    private RouteHeader contactRoute;
    private String user;
    private RouteHeader defaultRoute;
    private SIPTransactionStack sipStack;
    private int dialogState = -1;
    protected boolean ackSeen;
    protected Request lastAck;
    private URI requestURI;
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    private Address remoteTarget;
    public static final int INITIAL_STATE = -1;
    public static final int EARLY_STATE = 1;
    public static final int CONFIRMED_STATE = 2;
    public static final int COMPLETED_STATE = 3;
    public static final int TERMINATED_STATE = 4;

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    private void printRouteList() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("this : " + this);
            LogWriter.logMessage("printRouteList : " + this.routeList.encode());
            if (this.contactRoute != null) {
                LogWriter.logMessage("contactRoute : " + this.contactRoute.encode());
            } else {
                LogWriter.logMessage("contactRoute : null");
            }
        }
    }

    public Hop getNextHop() throws SipException {
        String transport;
        RouteList rl = this.getRouteList();
        SipURI sipUri = null;
        if (rl != null && !rl.isEmpty()) {
            RouteHeader route = (RouteHeader)this.getRouteList().getFirst();
            sipUri = (SipURI)route.getAddress().getURI();
        } else if (this.contactRoute != null) {
            sipUri = (SipURI)this.contactRoute.getAddress().getURI();
        } else {
            throw new SipException("No route found!");
        }
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        int port = sipUri.getPort();
        if (port == -1) {
            port = 5060;
        }
        if ((transport = sipUri.getTransportParam()) == null) {
            transport = this.firstTransaction.getViaHeader().getTransport();
        }
        return new Hop(host, port, transport);
    }

    public boolean isClientDialog() {
        Transaction transaction = this.getFirstTransaction();
        return transaction instanceof ClientTransaction;
    }

    public void setState(int state) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Setting dialog state for " + this + " to " + state);
            if (state != -1 && state != this.dialogState && LogWriter.needsLogging) {
                LogWriter.logMessage("New dialog state is " + state + "dialogId = " + this.getDialogId());
            }
        }
        this.dialogState = state;
    }

    public void printTags() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("isServer = " + this.isServer());
            LogWriter.logMessage("localTag = " + this.getLocalTag());
            LogWriter.logMessage("remoteTag = " + this.getRemoteTag());
            LogWriter.logMessage("firstTransaction = " + this.firstTransaction.getOriginalRequest());
        }
    }

    public void ackReceived(Request sipRequest) {
        if (this.isServer()) {
            ServerTransaction st = (ServerTransaction)this.getFirstTransaction();
            if (st == null) {
                return;
            }
            if (st.getOriginalRequest().getCSeqHeader().getSequenceNumber() == sipRequest.getCSeqHeader().getSequenceNumber()) {
                st.setState(6);
                this.ackSeen = true;
                this.lastAck = sipRequest;
            }
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public Request getLastAck() {
        return this.lastAck;
    }

    public void setFirstTransaction(Transaction firstTransaction) {
        this.firstTransaction = firstTransaction;
        this.localSequenceNumber = firstTransaction.getOriginalRequest().getCSeqHeaderNumber();
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Enumeration getRouteSet() {
        if (this.routeList == null) {
            return null;
        }
        return this.getRouteList().getElements();
    }

    private RouteList getRouteList() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("getRouteList " + this.getDialogId());
        }
        Vector li = this.routeList.getHeaders();
        RouteList retval = new RouteList();
        int i = 0;
        while (i < li.size()) {
            RouteHeader route = (RouteHeader)li.elementAt(i);
            retval.add(route.clone());
            ++i;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("----->>> ");
            LogWriter.logMessage("getRouteList for " + this);
            LogWriter.logMessage("RouteList = " + retval.encode());
            LogWriter.logMessage("myRouteList = " + this.routeList.encode());
            LogWriter.logMessage("----->>> ");
        }
        return retval;
    }

    public void setStack(SIPTransactionStack sipStack) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Setting stack of dialog " + this + " with ID " + this.dialogId + " to " + sipStack);
        }
        this.sipStack = sipStack;
    }

    public void setDefaultRoute(RouteHeader defaultRoute) {
        this.defaultRoute = (RouteHeader)defaultRoute.clone();
    }

    public void setUser(String user) {
        this.user = user;
    }

    private void addRoute(RecordRouteList recordRouteList) {
        if (this.isClientDialog()) {
            this.routeList = new RouteList();
            Vector li = recordRouteList.getHeaders();
            int i = li.size() - 1;
            while (i >= 0) {
                RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(i);
                Address addr = rr.getAddress();
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)rr.getAddress().clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.routeList.add(route);
                --i;
            }
        } else {
            this.routeList = new RouteList();
            Vector li = recordRouteList.getHeaders();
            int i = 0;
            while (i < li.size()) {
                RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(i);
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)rr.getAddress().clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.routeList.add(route);
                ++i;
            }
        }
    }

    private void addRoute(ContactList contactList) {
        if (contactList == null || contactList.size() == 0) {
            return;
        }
        ContactHeader contact = (ContactHeader)contactList.getFirst();
        RouteHeader route = new RouteHeader();
        route.setAddress((Address)contact.getAddress().clone());
        this.contactRoute = route;
    }

    public synchronized void addRoute(Message sipMessage) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("addRoute: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 2 && sipMessage instanceof Request && Request.isTargetRefresh(((Request)sipMessage).getMethod())) {
            this.doTargetRefresh(sipMessage);
        }
        if (this.dialogState == 2 || this.dialogState == 3 || this.dialogState == 4) {
            return;
        }
        RecordRouteList rrlist = sipMessage.getRecordRouteHeaders();
        if (rrlist != null) {
            this.addRoute(rrlist);
        } else {
            this.routeList = new RouteList();
        }
        this.addRoute(sipMessage.getContactHeaders());
        if (sipMessage.getContactHeaders() != null) {
            this.setRemoteTarget((ContactHeader)sipMessage.getContactHeaders().getFirst());
        }
    }

    private void doTargetRefresh(Message sipMessage) {
        ContactList contactList = sipMessage.getContactHeaders();
        if (contactList != null) {
            ContactHeader contact = (ContactHeader)contactList.getFirst();
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Doing target refresh for " + sipMessage.getFirstLine() + " with contact " + contact.encode());
            }
            this.setRemoteTarget(contact);
        }
    }

    private void setRemoteTarget(ContactHeader contact) {
        this.remoteTarget = contact.getAddress();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Dialog.setRemoteTarget: " + this.remoteTarget.encode());
        }
    }

    private Dialog() {
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    protected Dialog(Transaction transaction) {
        this();
        if (transaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.addTransaction(transaction);
    }

    public boolean isServer() {
        return this.getFirstTransaction() instanceof ServerTransaction;
    }

    public String getDialogId() {
        if (this.firstTransaction instanceof ServerTransaction) {
            Request sipRequest = ((ServerTransaction)this.firstTransaction).getOriginalRequest();
            this.dialogId = sipRequest.getDialogId(true, this.myTag);
        } else if (this.firstTransaction != null && ((ClientTransaction)this.firstTransaction).getLastResponse() != null) {
            this.dialogId = ((ClientTransaction)this.getFirstTransaction()).getLastResponse().getDialogId(false, this.hisTag);
        }
        return this.dialogId;
    }

    public void addTransaction(Transaction transaction) {
        Request sipRequest = transaction.getOriginalRequest();
        if (sipRequest.getMethod().equals("BYE")) {
            this.setState(3);
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = transaction;
            if (transaction instanceof ServerTransaction) {
                this.hisTag = sipRequest.getFromHeader().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeqHeader().getSequenceNumber());
                this.myTag = sipRequest.getFromHeader().getTag();
                if (this.myTag == null) {
                    throw new RuntimeException("bad message tag missing!");
                }
            }
        } else if (transaction.getOriginalRequest().getMethod().equals(this.firstTransaction.getOriginalRequest().getMethod()) && (this.firstTransaction instanceof ServerTransaction && transaction instanceof ClientTransaction || this.firstTransaction instanceof ClientTransaction && transaction instanceof ServerTransaction)) {
            this.firstTransaction = transaction;
        }
        if (transaction instanceof ServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeqHeader().getSequenceNumber());
        }
        this.lastTransaction = transaction;
        transaction.setDialog(this);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Transaction Added " + transaction + " to dialog " + this + " tags: " + this.myTag + " / " + this.hisTag);
            LogWriter.logMessage("TID = " + transaction.getTransactionId() + "/" + transaction.IsServerTransaction());
        }
    }

    public void setRemoteTag(String hisTag) {
        this.hisTag = hisTag;
    }

    public Transaction getLastTransaction() {
        return this.lastTransaction;
    }

    public void setLastTransaction(Transaction lastTransaction) {
        this.lastTransaction = lastTransaction;
    }

    protected void setLocalSequenceNumber(int lCseq) {
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(int rCseq) {
        this.remoteSequenceNumber = rCseq;
    }

    public int incrementLocalSequenceNumber() {
        return ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String mytag) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("set Local tag " + mytag + " " + this.dialogId);
        }
        this.myTag = mytag;
    }

    protected void deleteTransactions() {
        this.firstTransaction = null;
        this.lastTransaction = null;
    }

    public void delete() {
        this.setState(4);
    }

    public CallIdHeader getCallId() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        return sipRequest.getCallId();
    }

    public Address getLocalParty() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        if (!this.isServer()) {
            return sipRequest.getFromHeader().getAddress();
        }
        return sipRequest.getTo().getAddress();
    }

    public Address getRemoteParty() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        if (!this.isServer()) {
            return sipRequest.getTo().getAddress();
        }
        return sipRequest.getFromHeader().getAddress();
    }

    public Address getRemoteTarget() {
        return this.remoteTarget;
    }

    public int getState() {
        return this.dialogState;
    }

    public boolean isSecure() {
        return Utils.equalsIgnoreCase(this.getFirstTransaction().getRequest().getRequestURI().getScheme(), "sips");
    }

    public void sendAck(Request request) throws SipException {
        Request ackRequest = request;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("sendAck" + this);
        }
        if (this.isServer()) {
            throw new SipException("Cannot sendAck from Server side of Dialog");
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == -1 || this.getState() == 1) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getFirstTransaction().getOriginalRequest().getCallId().getCallId().equals(request.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("setting from tag For outgoing ACK= " + this.getLocalTag());
            LogWriter.logMessage("setting ToHeader tag for outgoing ACK = " + this.getRemoteTag());
        }
        if (this.getLocalTag() != null) {
            ackRequest.getFromHeader().setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            ackRequest.getTo().setTag(this.getRemoteTag());
        }
        if (ackRequest.getHeader("Route") == null) {
            RouteList rl = this.getRouteList();
            if (rl.size() > 0) {
                RouteHeader route = (RouteHeader)rl.getFirst();
                SipURI sipUri = (SipURI)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    ackRequest.setRequestURI(this.getRemoteTarget().getURI());
                    ackRequest.addHeader(rl);
                } else {
                    rl.removeFirst();
                    ackRequest.setRequestURI(sipUri);
                    if (rl.size() > 0) {
                        ackRequest.addHeader(rl);
                    }
                    if (this.contactRoute != null) {
                        ackRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                ackRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        Hop hop = this.getNextHop();
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (messageChannel == null) {
                Hop outboundProxy;
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "Still no message channel for ACK. Trying Outbound Proxy");
                }
                if ((outboundProxy = this.sipStack.getRouter().getOutboundProxy()) == null) {
                    throw new SipException("No route found!");
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Message channel for ACK: " + messageChannel.getPeerHostPort().encode());
            }
            ClientTransaction clientTransaction = (ClientTransaction)this.sipStack.createMessageChannel(messageChannel);
            clientTransaction.setOriginalRequest(ackRequest);
            clientTransaction.sendMessage(ackRequest);
            this.lastAck = ackRequest;
            clientTransaction.setState(6);
        }
        catch (Exception ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logException(ex);
            }
            throw new SipException("Could not create message channel for ACK (" + ex.getClass() + " : " + ex.getMessage() + ")");
        }
    }

    public Request createRequest(String method) throws SipException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Creating " + method + " inside dialog");
        }
        if (method == null) {
            throw new NullPointerException("null method");
        }
        if (this.getState() == -1 || !method.equals("BYE") && this.getState() == 4 || method.equals("BYE") && this.getState() == 1) {
            throw new SipException("Dialog not yet established or terminated " + this.getState());
        }
        Request originalRequest = this.getFirstTransaction().getRequest();
        SipURI sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipURI)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipURI)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Cloned request with R-URI: " + sipUri);
        }
        RequestLine requestLine = new RequestLine();
        requestLine.setUri(sipUri);
        requestLine.setMethod(method);
        sipUri = null;
        Request sipRequest = originalRequest.createRequest(requestLine, this.isServer());
        try {
            CSeqHeader cseq = StackConnector.headerFactory.createCSeqHeader(this.incrementLocalSequenceNumber(), method);
            sipRequest.setCSeqHeader(cseq);
        }
        catch (IllegalArgumentException e) {
            InternalErrorHandler.handleException(e);
            e.printStackTrace();
        }
        catch (ParseException e) {
            InternalErrorHandler.handleException(e);
            e.printStackTrace();
        }
        sipRequest.addHeader(originalRequest.getContactHeaders());
        if (this.isServer()) {
            sipRequest.removeHeader("Via");
            MessageProcessor messageProcessor = this.sipStack.getMessageProcessor(this.firstTransaction.encapsulatedChannel.getTransport());
            ViaHeader via = messageProcessor.getViaHeader();
            sipRequest.addHeader(via);
        }
        FromHeader from = sipRequest.getFromHeader();
        ToHeader to = sipRequest.getTo();
        if (this.getLocalTag() != null) {
            from.setTag(this.getLocalTag());
        } else {
            from.removeTag();
        }
        if (this.getRemoteTag() != null) {
            to.setTag(this.getRemoteTag());
        } else {
            to.removeTag();
        }
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            RouteHeader route = (RouteHeader)rl.getFirst();
            SipURI sipUri2 = (SipURI)route.getAddress().getURI();
            if (sipUri2.hasLrParam()) {
                sipRequest.setRequestURI(this.getRemoteTarget().getURI());
                sipRequest.addHeader(rl);
            } else {
                rl.removeFirst();
                sipRequest.setRequestURI(sipUri2);
                if (rl.size() > 0) {
                    sipRequest.addHeader(rl);
                }
                if (this.contactRoute != null) {
                    sipRequest.addHeader(this.contactRoute);
                }
            }
        } else if (this.getRemoteTarget() != null) {
            sipRequest.setRequestURI(this.getRemoteTarget().getURI());
        }
        if (method.equals("SUBSCRIBE")) {
            if (originalRequest.getHeader("Event") != null) {
                sipRequest.addHeader(originalRequest.getHeader("Event"));
            }
            if (originalRequest.getHeader("Expires") != null) {
                sipRequest.addHeader(originalRequest.getHeader("Expires"));
            }
            if (originalRequest.getHeader("Supported") != null) {
                sipRequest.addHeader(originalRequest.getHeader("Supported"));
            }
        }
        if (originalRequest.getHeader("P-Preferred-Identity") != null) {
            sipRequest.addHeader(originalRequest.getHeader("P-Preferred-Identity"));
        }
        return sipRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendRequest(ClientTransaction clientTransactionId) throws SipException {
        Request dialogRequest = clientTransactionId.getOriginalRequest();
        if (clientTransactionId == null) {
            // empty if block
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.getState() == -1) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (Utils.equalsIgnoreCase(dialogRequest.getMethod(), "BYE") && this.getState() == 1) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (dialogRequest.getTopmostVia() == null) {
            ViaHeader via = clientTransactionId.getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getFirstTransaction().getOriginalRequest().getCallId().getCallId().equals(dialogRequest.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        clientTransactionId.dialog = this;
        FromHeader from = dialogRequest.getFromHeader();
        ToHeader to = dialogRequest.getTo();
        if (this.getLocalTag() != null && from.getTag() != null && !from.getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting\t " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag())) {
            throw new SipException("To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && dialogRequest.getMethod().equals("NOTIFY")) {
            if (!clientTransactionId.getOriginalRequest().getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(from.getTag());
        }
        if (this.getLocalTag() != null) {
            from.setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            to.setTag(this.getRemoteTag());
        }
        if (dialogRequest.getHeader("Route") == null) {
            RouteList rl = this.getRouteList();
            if (rl.size() > 0) {
                RouteHeader route = (RouteHeader)rl.getFirst();
                SipURI sipUri = (SipURI)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
                    dialogRequest.addHeader(rl);
                } else {
                    rl.removeFirst();
                    dialogRequest.setRequestURI(sipUri);
                    if (rl.size() > 0) {
                        dialogRequest.addHeader(rl);
                    }
                    if (this.contactRoute != null) {
                        dialogRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("At this point, RURI is: " + dialogRequest.getRequestLine().encode());
        }
        Hop hop = clientTransactionId.getNextHop();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Using hop = " + hop.getHost() + " : " + hop.getPort());
        }
        try {
            MessageChannel messageChannel;
            clientTransactionId.encapsulatedChannel = messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (messageChannel == null) {
                Hop outboundProxy = this.sipStack.getRouter().getOutboundProxy();
                if (outboundProxy == null) {
                    throw new SipException("No route found!");
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            clientTransactionId.encapsulatedChannel = messageChannel;
        }
        catch (Exception ex) {
            if (!LogWriter.needsLogging) throw new SipException("Could not create message channel for request " + clientTransactionId.getRequest().getFirstLine());
            LogWriter.logException(ex);
            throw new SipException("Could not create message channel for request " + clientTransactionId.getRequest().getFirstLine());
        }
        if (this.isServer()) {
            ServerTransaction serverTransaction = (ServerTransaction)this.getFirstTransaction();
            from.setTag(this.myTag);
            to.setTag(this.hisTag);
            try {
                clientTransactionId.sendMessage(dialogRequest);
                if (!dialogRequest.getMethod().equals("BYE")) return;
                this.setState(3);
                return;
            }
            catch (IOException ex) {
                throw new SipException("error sending message");
            }
        }
        ClientTransaction clientTransaction = (ClientTransaction)this.getFirstTransaction();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("setting tags from " + this.getDialogId());
            LogWriter.logMessage("fromTag " + this.myTag);
            LogWriter.logMessage("toTag " + this.hisTag);
        }
        from.setTag(this.myTag);
        to.setTag(this.hisTag);
        try {
            clientTransactionId.sendMessage(dialogRequest);
            if (!dialogRequest.getMethod().equals("BYE")) return;
            this.setState(3);
            return;
        }
        catch (IOException ex) {
            throw new SipException("error sending message");
        }
    }

    protected boolean toRetransmitFinalResponse() {
        if (--this.retransmissionTicksLeft == 0) {
            this.prevRetransmissionTicks = this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() {
        try {
            if (this.lastAck != null) {
                this.sendAck(this.lastAck);
            }
        }
        catch (SipException ex) {
            ex.printStackTrace();
        }
    }

    protected boolean isInviteDialog() {
        return this.getFirstTransaction().getRequest().getMethod().equals("INVITE");
    }
}

