/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.address;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.URI;

public class Address
extends GenericObject {
    public static final int NAME_ADDR = 1;
    public static final int ADDRESS_SPEC = 2;
    public static final int WILD_CARD = 3;
    protected int addressType = 1;
    protected String displayName;
    protected URI address;

    public HostPort getHostPort() {
        if (!(this.address instanceof SipURI)) {
            throw new RuntimeException("address is not a SipURI");
        }
        SipURI uri = (SipURI)this.address;
        return uri.getHostPort();
    }

    public int getPort() {
        if (!(this.address instanceof SipURI)) {
            throw new RuntimeException("address is not a SipURI");
        }
        SipURI uri = (SipURI)this.address;
        return uri.getHostPort().getPort();
    }

    public String getUserAtHostPort() {
        if (this.address instanceof SipURI) {
            SipURI uri = (SipURI)this.address;
            return uri.getUserAtHostPort();
        }
        return this.address.toString();
    }

    public String getHost() {
        if (!(this.address instanceof SipURI)) {
            throw new RuntimeException("address is not a SipURI");
        }
        SipURI uri = (SipURI)this.address;
        return uri.getHostPort().getHost().getHostname();
    }

    public void removeParameter(String parameterName) {
        if (!(this.address instanceof SipURI)) {
            throw new RuntimeException("address is not a SipURI");
        }
        SipURI uri = (SipURI)this.address;
        uri.removeParameter(parameterName);
    }

    public String encode() {
        if (this.addressType == 3) {
            return "*";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.displayName != null) {
            encoding.append("\"").append(this.displayName).append("\"").append(" ");
        }
        if (this.address != null) {
            if (this.addressType == 1 || this.displayName != null) {
                encoding.append("<");
            }
            encoding.append(this.address.encode());
            if (this.addressType == 1 || this.displayName != null) {
                encoding.append(">");
            }
        }
        return encoding.toString();
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int atype) {
        this.addressType = atype;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.addressType = 1;
    }

    public void setURI(URI address) {
        this.address = address;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Address that = (Address)other;
        if (this.addressType == 3 && that.addressType != 3) {
            return false;
        }
        boolean retval = this.address.equals(that.address);
        return retval;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public void removeDisplayName() {
        this.displayName = null;
    }

    public boolean isSIPAddress() {
        return this.address instanceof SipURI;
    }

    public URI getURI() {
        return this.address;
    }

    public boolean isWildcard() {
        return this.addressType == 3;
    }

    public void setUser(String user) {
        ((SipURI)this.address).setUser(user);
    }

    public Object clone() {
        Address retval = new Address();
        retval.addressType = this.addressType;
        if (this.displayName != null) {
            retval.displayName = new String(this.displayName);
        }
        if (this.address != null) {
            retval.address = (URI)this.address.clone();
        }
        return retval;
    }
}

