/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.core.net.NetworkLayer;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.ConfigurationProperties;
import sip4me.gov.nist.siplite.EventScanner;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.NistSipMessageFactoryImpl;
import sip4me.gov.nist.siplite.ObjectInUseException;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.address.Router;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPTransactionErrorEvent;
import sip4me.gov.nist.siplite.stack.SIPTransactionStack;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.gov.nist.siplite.stack.Transaction;

public class SipStack
extends SIPTransactionStack {
    private final Hashtable listeningPoints;
    private final Vector sipProviders;
    protected boolean stackInitialized;
    protected String routerPath;
    protected EventScanner eventScanner;
    protected SipListener sipListener;
    protected StackConnector sipStackConnector;

    public void setStackConnector(StackConnector stackConnector) {
        this.sipStackConnector = stackConnector;
    }

    protected SipStack() {
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl();
        super.setMessageFactory(msgFactory);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new Vector();
    }

    public void stopStack() {
        super.stopStack();
        this.eventScanner.stop();
        this.eventScanner = null;
        StackConnector.releaseInstance();
    }

    public SipStack(ConfigurationProperties configurationProperties) throws IllegalArgumentException {
        String transactionTableSize;
        String threadPoolSize;
        String serverLog;
        String badMessageLog;
        String logLevel;
        String extensionMethods;
        block35: {
            String netLayerPath;
            block34: {
                this();
                this.eventScanner = new EventScanner(this);
                this.eventScanner.start();
                String address = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
                if (address == null) {
                    throw new IllegalArgumentException("address not specified");
                }
                super.setHostAddress(address);
                String name = configurationProperties.getProperty("javax.sip.STACK_NAME");
                if (name == null) {
                    throw new IllegalArgumentException("stack name is missing");
                }
                super.setStackName(name);
                String readTimeout = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.READ_TIMEOUT");
                if (readTimeout != null) {
                    try {
                        int rt = Integer.parseInt(readTimeout);
                        if (rt >= 2000) {
                            this.readTimeout = rt;
                        } else {
                            System.err.println("Value too low " + readTimeout);
                            this.readTimeout = 2000;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!LogWriter.needsLogging) break block34;
                        LogWriter.logMessage(32, "Bad read timeout " + readTimeout);
                    }
                }
            }
            if ((netLayerPath = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.NETWORK_LAYER")) != null) {
                try {
                    Class<?> netLayerClass = Class.forName(netLayerPath);
                    NetworkLayer nl = (NetworkLayer)netLayerClass.newInstance();
                    if (nl != null) {
                        super.setNetworkLayer(nl);
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.needsLogging) break block35;
                    LogWriter.logMessage(2, "Could not load required Network Layer: " + netLayerPath);
                }
            }
        }
        this.routerPath = "sip4me.gov.nist.siplite.stack.DefaultRouter";
        String outboundProxy = configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY");
        try {
            Class<?> routerClass = Class.forName(this.routerPath);
            Router router = (Router)routerClass.newInstance();
            if (outboundProxy != null) {
                router.setOutboundProxy(outboundProxy);
            }
            router.setSipStack(this);
            super.setRouter(router);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Could not instantiate router");
        }
        if (outboundProxy != null) {
            Hop hop = new Hop(outboundProxy);
            this.outboundProxy = hop.getHost();
            this.outboundPort = hop.getPort();
        }
        if ((extensionMethods = configurationProperties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            StringTokenizer st = new StringTokenizer(extensionMethods, ':');
            while (st.hasMoreChars()) {
                String em = st.nextToken();
                if (em.toUpperCase().equals("BYE") || em.toUpperCase().equals("ACK") || em.toUpperCase().equals("OPTIONS")) {
                    throw new IllegalArgumentException("Bad extension method " + em);
                }
                this.addExtensionMethod(em.toUpperCase());
            }
        }
        this.retransmissionFilter = true;
        String debugLog = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.LOG_FILE_NAME");
        if (debugLog != null) {
            LogWriter.setLogFileName(debugLog);
        }
        if ((logLevel = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.TRACE_LEVEL")) != null) {
            try {
                int ll = Integer.parseInt(logLevel);
                if (ll == 32) {
                    LogWriter.needsLogging = true;
                }
                ServerLog.setTraceLevel(ll);
            }
            catch (NumberFormatException ex) {
                System.out.println("WARNING Bad integer " + logLevel);
                System.out.println("logging dislabled ");
                ServerLog.setTraceLevel(0);
            }
        }
        if ((badMessageLog = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.BAD_MESSAGE_LOG")) != null) {
            this.badMessageLog = badMessageLog;
        }
        if ((serverLog = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.SERVER_LOG")) != null) {
            ServerLog.setLogFileName(serverLog);
        }
        ServerLog.checkLogFile();
        String maxConnections = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.MAX_CONNECTIONS");
        if (maxConnections != null) {
            try {
                this.maxConnections = Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException ex) {
                System.out.println("max connections - bad value " + ex.getMessage());
            }
        }
        if ((threadPoolSize = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = Integer.parseInt(threadPoolSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("thread pool size - bad value " + ex.getMessage());
            }
        }
        if ((transactionTableSize = configurationProperties.getProperty("sip4me.gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.transactionTableSize = Integer.parseInt(transactionTableSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("transaction table size - bad value " + ex.getMessage());
            }
        }
    }

    public SipListener getSipListener() {
        return this.sipListener;
    }

    public synchronized ListeningPoint createListeningPoint(int port, String transport) throws IllegalArgumentException {
        String key;
        ListeningPoint lip;
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("bad port");
        }
        if (!Utils.equalsIgnoreCase(transport, "UDP") && !Utils.equalsIgnoreCase(transport, "TCP")) {
            throw new IllegalArgumentException("Transport not supported: " + transport);
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("createListeningPoint " + transport + " / " + port);
        }
        if ((lip = (ListeningPoint)this.listeningPoints.get(key = ListeningPoint.makeKey(this.stackAddress, port, transport))) != null) {
            return lip;
        }
        try {
            MessageProcessor messageProcessor = this.createMessageProcessor(port, transport);
            lip = new ListeningPoint(this, port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            return lip;
        }
        catch (IOException ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "Exception creating listening point. Maybe port is in use? " + ex.getMessage());
            }
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        ListeningPoint listeningPointImpl = listeningPoint;
        if (listeningPointImpl.sipProviderImpl != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProvider provider = new SipProvider(this);
        provider.addListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProviderImpl = provider;
        this.sipProviders.addElement(provider);
        return provider;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        String key;
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPoint lip = listeningPoint;
        if (lip.messageProcessor != null) {
            this.removeMessageProcessor(lip.messageProcessor);
            lip.messageProcessor = null;
        }
        if ((key = lip.getKey()) != null) {
            this.listeningPoints.remove(key);
        }
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Deleting SIP provider " + sipProvider + " from Stack");
        }
        sipProvider.stop();
        sipProvider.sipListener = null;
        this.sipProviders.removeElement(sipProvider);
        if (this.sipProviders.isEmpty() && this.listeningPoints.isEmpty()) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("No more SipProviders/Listening Points: stopping stack!");
            }
            this.stopStack();
        }
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Enumeration getListeningPoints() {
        return this.listeningPoints.elements();
    }

    public ListeningPoint getListeningPoint(int port, String transport) {
        String key = ListeningPoint.makeKey(this.stackAddress, port, transport);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("getListeningPoint " + port + "/" + transport);
        }
        return (ListeningPoint)this.listeningPoints.get(key);
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public boolean isRetransmissionFilterActive() {
        return this.retransmissionFilter;
    }

    public Router getRouter() {
        return super.getRouter();
    }

    public Enumeration getSipProviders() {
        return this.sipProviders.elements();
    }

    public String getStackName() {
        return this.stackName;
    }

    protected String getDefaultTransport() {
        if (this.isTransportEnabled("udp")) {
            return "udp";
        }
        if (this.isTransportEnabled("tcp")) {
            return "tcp";
        }
        return null;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        Transaction transaction = transactionErrorEvent.getSource();
    }
}

