/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.io.j2me;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.microedition.io.j2me.sip.DistributedRandom;
import sip4me.gov.nist.microedition.sip.ConnectionBaseInterface;
import sip4me.gov.nist.microedition.sip.StackConnector;

public abstract class Protocol
implements ConnectionBaseInterface {
    protected StackConnector stackConnector;

    public Connection openPrim(String name, int mode, boolean timeout) throws IOException, IllegalArgumentException {
        this.stackConnector = null;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(16, "Trying to open connection from String: " + name);
        }
        int indexOfAt = name.indexOf("@");
        int indexOfSemiColon = name.indexOf(";");
        int indexOfColon = name.indexOf(":");
        int indexOfPlus = name.indexOf("+");
        if (indexOfSemiColon != -1 && indexOfColon > indexOfSemiColon) {
            indexOfColon = -1;
        }
        if (indexOfPlus > 0) {
            indexOfPlus = -1;
        }
        if (indexOfSemiColon != -1 && indexOfAt > indexOfSemiColon) {
            indexOfAt = -1;
        }
        if (indexOfColon == 0) {
            throw new IllegalArgumentException("Bad SIP URI: no colon");
        }
        if (this instanceof sip4me.gov.nist.microedition.io.j2me.sip.Protocol) {
            if (name == null || name.length() < 1 || name.equals("*")) {
                this.openSipConnectionNotifier(new DistributedRandom().nextInt(8975) + 1024, false, null);
            }
            if (name.length() == 4 && indexOfAt == -1 && indexOfColon == -1 && indexOfPlus == -1 && indexOfSemiColon == -1) {
                try {
                    int portNumber = Integer.parseInt(name);
                    return this.openSipConnectionNotifier(portNumber, false, null);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("the port you have entered for the SipConnectionNotifier seems to be wrong");
                }
            }
            if (indexOfSemiColon == 0) {
                Vector parameters = this.parseAndCheckParameters(name.substring(indexOfSemiColon + 1));
                return this.openSipConnectionNotifier(new DistributedRandom().nextInt(8975) + 1024, false, parameters);
            }
            if (indexOfAt == -1 && indexOfColon == -1 && indexOfSemiColon != -1 && indexOfPlus == -1) {
                String port = name.substring(0, indexOfSemiColon);
                Vector parameters = this.parseAndCheckParameters(name.substring(indexOfSemiColon + 1));
                if (port.length() == 4) {
                    try {
                        int portNumber = Integer.parseInt(port);
                        return this.openSipConnectionNotifier(portNumber, false, parameters);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("the port you have entered for the SipConnectionNotifier seems to be wrong");
                    }
                }
                throw new IllegalArgumentException("the port you have entered for the SipConnectionNotifier seems to be wrong");
            }
        }
        if (indexOfAt != -1 && indexOfColon == -1 && indexOfSemiColon == -1 && indexOfPlus == -1) {
            return this.openSipClientConnection(name.substring(0, indexOfAt), name.substring(indexOfAt + 1), -1, false, null);
        }
        if (indexOfColon == -1 && indexOfSemiColon == -1 && indexOfPlus != -1) {
            String tel = null;
            String host = null;
            if (indexOfAt != -1) {
                tel = name.substring(0, indexOfAt);
                host = name.substring(indexOfAt + 1);
            } else {
                tel = name;
            }
            try {
                Long.parseLong(tel.substring(1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the Telephone number you have entered seems to contain characters.");
            }
            return this.openSipClientConnection(tel, host, -1, false, null);
        }
        if (indexOfAt != -1 && indexOfColon != -1 && indexOfSemiColon == -1 && indexOfPlus == -1) {
            String user = name.substring(0, indexOfAt);
            String host = name.substring(indexOfAt + 1, indexOfColon);
            String port = name.substring(indexOfColon + 1);
            int portNumber = -1;
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the port you have entered for the SipClientConnection seems to be wrong");
            }
            return this.openSipClientConnection(user, host, portNumber, false, null);
        }
        if (indexOfColon != -1 && indexOfSemiColon == -1 && indexOfPlus != -1) {
            String tel = null;
            String host = null;
            String port = null;
            int portNumber = -1;
            if (indexOfAt != -1) {
                tel = name.substring(0, indexOfAt);
                host = name.substring(indexOfAt + 1, indexOfColon);
                port = name.substring(indexOfColon + 1);
            } else {
                tel = name.substring(0, indexOfColon);
                port = name.substring(indexOfColon + 1);
            }
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the port you have entered for the SipClientConnection seems to be wrong");
            }
            try {
                Long.parseLong(tel.substring(1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the Telephone number you have entered seems to contain characters.");
            }
            return this.openSipClientConnection(tel, host, portNumber, false, null);
        }
        if (indexOfAt != -1 && indexOfSemiColon != -1 && indexOfPlus == -1) {
            String user = name.substring(0, indexOfAt);
            String host = null;
            String port = null;
            if (indexOfColon != -1) {
                host = name.substring(indexOfAt + 1, indexOfColon);
                port = name.substring(indexOfColon + 1, indexOfSemiColon);
            } else {
                host = name.substring(indexOfAt + 1, indexOfSemiColon);
                port = "-1";
            }
            Vector parameters = this.parseAndCheckParameters(name.substring(indexOfSemiColon + 1));
            int portNumber = -1;
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the port you have entered for the SipClientConnection seems to be wrong");
            }
            return this.openSipClientConnection(user, host, portNumber, false, parameters);
        }
        if (indexOfSemiColon != -1 && indexOfPlus != -1) {
            String tel = null;
            String host = null;
            String port = null;
            if (indexOfAt != -1) {
                tel = name.substring(0, indexOfAt);
                if (indexOfColon != -1) {
                    host = name.substring(indexOfAt + 1, indexOfColon);
                    port = name.substring(indexOfColon + 1, indexOfSemiColon);
                } else {
                    host = name.substring(indexOfAt + 1, indexOfSemiColon);
                    port = "-1";
                }
            } else if (indexOfColon != -1) {
                tel = name.substring(0, indexOfColon);
                port = name.substring(indexOfColon + 1, indexOfSemiColon);
            } else {
                tel = name.substring(0, indexOfSemiColon);
                port = "-1";
            }
            try {
                Long.parseLong(tel.substring(1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the Telephone number you have entered seems to contain characters.");
            }
            Vector parameters = this.parseAndCheckParameters(name.substring(indexOfSemiColon + 1));
            int portNumber = -1;
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the port you have entered for the SipClientConnection seems to be wrong");
            }
            return this.openSipClientConnection(tel, host, portNumber, false, parameters);
        }
        if (indexOfAt == -1 && indexOfColon == -1 && indexOfPlus == -1) {
            String tel = null;
            Vector parameters = null;
            if (indexOfSemiColon != -1) {
                tel = name.substring(0, indexOfSemiColon);
                parameters = this.parseAndCheckParameters(name.substring(indexOfSemiColon + 1));
            } else {
                tel = name;
            }
            try {
                Long.parseLong(tel);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("the Telephone number you have entered seems to contain characters.");
            }
            return this.openSipClientConnection(tel, null, -1, false, parameters);
        }
        throw new ConnectionNotFoundException("Connection could not be created. No pattern matched.");
    }

    protected abstract Connection openSipConnectionNotifier(int var1, boolean var2, Vector var3) throws IOException;

    protected abstract Connection openSipClientConnection(String var1, String var2, int var3, boolean var4, Vector var5) throws IOException, IllegalArgumentException;

    protected Vector parseAndCheckParameters(String parametersString) throws IllegalArgumentException {
        Vector<String> params = new Vector<String>();
        if (parametersString == null || parametersString.length() == 0) {
            return params;
        }
        StringTokenizer st = new StringTokenizer(parametersString, ';');
        while (st.hasMoreChars()) {
            String parameter = st.nextToken();
            if (parameter.endsWith(";")) {
                parameter = parameter.substring(0, parameter.length() - 1);
            }
            if (parameter.indexOf("=") == -1) {
                throw new IllegalArgumentException("One of the parameters inthe URI doesn't follow the expected syntax 'name=value'");
            }
            params.addElement(parameter);
        }
        return params;
    }
}

