/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.ConnectionAddress;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class ConnectionField
extends SDPField {
    protected String nettype;
    protected String addrtype;
    protected ConnectionAddress address;

    public Object clone() {
        ConnectionField retval = new ConnectionField();
        retval.nettype = this.nettype;
        retval.addrtype = this.addrtype;
        if (this.address != null) {
            retval.address = (ConnectionAddress)this.address.clone();
        }
        return retval;
    }

    public ConnectionField() {
        super("c=");
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public ConnectionAddress getConnectionAddress() {
        return this.address;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrType(String a) {
        this.addrtype = a;
    }

    public void setAddress(ConnectionAddress a) {
        this.address = a;
    }

    public String encode() {
        String encoded_string = "c=";
        if (this.nettype != null) {
            encoded_string = String.valueOf(encoded_string) + this.nettype;
        }
        if (this.addrtype != null) {
            encoded_string = String.valueOf(encoded_string) + " " + this.addrtype;
        }
        if (this.address != null) {
            encoded_string = String.valueOf(encoded_string) + " " + this.address.encode();
        }
        encoded_string = String.valueOf(encoded_string) + "\r\n";
        return encoded_string;
    }

    public String toString() {
        return this.encode();
    }

    public String getAddress() throws SdpParseException {
        ConnectionAddress connectionAddress = this.getConnectionAddress();
        if (connectionAddress == null) {
            return null;
        }
        Host host = connectionAddress.getAddress();
        if (host == null) {
            return null;
        }
        return host.getAddress();
    }

    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("the addr is null");
        }
        if (this.address == null) {
            this.address = new ConnectionAddress();
            Host host = new Host(addr);
            this.address.setAddress(host);
        } else {
            Host host = this.address.getAddress();
            if (host == null) {
                host = new Host(addr);
                this.address.setAddress(host);
            } else {
                host.setAddress(addr);
            }
        }
        this.setAddress(this.address);
    }

    public void setAddressType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("the type is null");
        }
        this.addrtype = type;
    }

    public void setNetworkType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("the type is null");
        }
        this.setNettype(type);
    }
}

