/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.RtpException;
import org.linphone.jortp.SocketAddress;

public class SocketAddressImpl
implements SocketAddress {
    private String mHost;
    int mPort;
    int mRawAddress;
    boolean mRawAddressOk;

    public SocketAddressImpl(String host, int port) {
        this.mHost = host;
        this.mPort = port;
    }

    public SocketAddress.Family getFamily() {
        return SocketAddress.Family.Inet;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String toString() {
        return String.valueOf(this.getHost()) + ":" + this.getPort();
    }

    public int getRawAddress() throws RtpException {
        if (!this.mRawAddressOk) {
            long num;
            String tmp;
            long addr = 0L;
            int begin = 0;
            int bytecount = 0;
            int i = 0;
            while (i < this.mHost.length()) {
                if (this.mHost.charAt(i) == '.') {
                    tmp = this.mHost.substring(begin, i);
                    begin = i + 1;
                    num = Integer.parseInt(tmp);
                    addr |= num << 24 - 8 * bytecount;
                    ++bytecount;
                }
                ++i;
            }
            tmp = this.mHost.substring(begin, i);
            num = Integer.parseInt(tmp);
            addr |= num;
            if (++bytecount != 4) {
                throw new RtpException("Not an IP address");
            }
            this.mRawAddress = (int)(addr &= 0xFFFFFFFFFFFFFFFFL);
        }
        return this.mRawAddress;
    }
}

