/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import java.util.Vector;

public class Logger {
    static Vector sLoggers = new Vector();
    private String mDomain;
    private int mMask;
    public static final int Fatal = 16;
    public static final int Error = 24;
    public static final int Warn = 28;
    public static final int Info = 30;
    public static final int Debug = 31;
    static int sDefaultLevel = 28;
    static Handler sExternalHandler;

    public Logger(String domain) {
        if (domain == null) {
            domain = "";
        }
        this.mDomain = domain;
        this.mMask = sDefaultLevel;
        Logger.registerLogger(this);
    }

    public void setLogMask(int mask) {
        this.mMask = mask | 0x10;
    }

    public int getLogMask() {
        return this.mMask;
    }

    public boolean isLevelEnabled(int level) {
        return (level & this.mMask) != 0;
    }

    public void enableLogLevel(int level) {
        this.mMask |= level;
    }

    public void setLogLevel(int level) {
        this.mMask = level;
    }

    public void disableLogLevel(int level) {
        this.mMask &= ~this.mMask;
    }

    public void log(int level, String msg, Throwable e) {
        if (level > this.mMask) {
            return;
        }
        if (sExternalHandler != null) {
            sExternalHandler.log(this.mDomain, level, this.getLevelName(level), msg, e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mDomain);
        sb.append("-");
        sb.append(this.getLevelName(level));
        sb.append(":");
        sb.append(msg);
        if (e != null) {
            sb.append(" [" + e.getMessage() + "]");
        }
        System.out.println(sb.toString());
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void debug(String msg, Throwable e) {
        this.log(31, msg, e);
    }

    public void debug(String msg) {
        this.log(31, msg, null);
    }

    public void info(String msg) {
        this.log(30, msg, null);
    }

    public void info(String msg, Throwable e) {
        this.log(30, msg, e);
    }

    public void warn(String msg, Throwable e) {
        this.log(28, msg, e);
    }

    public void error(String msg, Throwable e) {
        this.log(24, msg, e);
    }

    public void fatal(String msg, Throwable e) {
        this.log(16, msg, e);
    }

    public String getLevelName(int level) {
        switch (level) {
            case 31: {
                return "Debug";
            }
            case 30: {
                return "Info";
            }
            case 28: {
                return "Warn";
            }
            case 24: {
                return "Error";
            }
            case 16: {
                return "Fatal";
            }
        }
        return "undef";
    }

    public static synchronized Logger getLogger(String domain) {
        int i = 0;
        while (i < sLoggers.size()) {
            Logger l = (Logger)sLoggers.elementAt(i);
            if (l != null && l.getDomain().equals(domain)) {
                return l;
            }
            ++i;
        }
        return new Logger(domain);
    }

    public static synchronized void setGlobalLogLevel(int level) {
        int i = 0;
        while (i < sLoggers.size()) {
            Logger l = (Logger)sLoggers.elementAt(i);
            l.setLogLevel(level);
            ++i;
        }
        sDefaultLevel = level;
    }

    public String getDomain() {
        return this.mDomain;
    }

    private static synchronized void registerLogger(Logger logger) {
        sLoggers.addElement(logger);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public static void setLogHandler(Handler anHandler) {
        sExternalHandler = anHandler;
    }

    public static interface Handler {
        public void log(String var1, int var2, String var3, String var4, Throwable var5);
    }
}

