/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.Node;

public class ListHead {
    private Node mRoot = new Node(this);
    private Node mEnd = new Node(this);

    public ListHead() {
        this.mRoot.mPrev = null;
        this.mRoot.mNext = this.mEnd;
        this.mEnd.mPrev = this.mRoot;
        this.mEnd.mNext = null;
    }

    public synchronized Node begin() {
        return this.mRoot.getNext();
    }

    public synchronized Node rbegin() {
        return this.mRoot;
    }

    public synchronized Node end() {
        return this.mEnd;
    }

    public synchronized Node rend() {
        return this.mEnd.mPrev;
    }

    public synchronized boolean empty() {
        return this.mRoot.mNext == this.mEnd;
    }

    public synchronized void pushBack(Node node) {
        this.mEnd.insertBefore(node);
    }

    public synchronized Node popFront() {
        if (this.empty()) {
            return null;
        }
        Node ret = this.begin();
        ret.remove();
        return ret;
    }

    public synchronized void clear() {
        while (this.popFront() != null) {
        }
    }
}

