/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.ListHead;
import org.linphone.jortp.Logger;
import org.linphone.jortp.PayloadType;
import org.linphone.jortp.PayloadTypeImpl;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpPacketImpl;
import org.linphone.jortp.RtpProfile;
import org.linphone.jortp.RtpProfileImpl;
import org.linphone.jortp.RtpSession;
import org.linphone.jortp.RtpSessionImpl;
import org.linphone.jortp.RtpTransport;
import org.linphone.jortp.SocketAddress;
import org.linphone.jortp.SocketAddressImpl;

public class JOrtpFactory {
    private static JOrtpFactory sInstance = null;
    private ListHead mRecycledPackets = new ListHead();
    private static Logger sLogger = Logger.getLogger("jortp");

    public static JOrtpFactory instance() {
        if (sInstance == null) {
            sInstance = new JOrtpFactory();
        }
        return sInstance;
    }

    public Logger createLogger(String domain) {
        return Logger.getLogger(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacket createRtpPacket(int dataSize) {
        ListHead listHead = this.mRecycledPackets;
        synchronized (listHead) {
            RtpPacket c;
            if (!this.mRecycledPackets.empty() && (c = (RtpPacket)((Object)this.mRecycledPackets.popFront())).getPhysicalSize() >= dataSize + RtpPacketImpl.sRtpHeaderSize) {
                byte[] b = c.getBytes();
                int i = 0;
                while (i < b.length) {
                    b[i] = 0;
                    ++i;
                }
                try {
                    c.setRealLength(dataSize + RtpPacketImpl.sRtpHeaderSize);
                    return c;
                }
                catch (RtpException e) {
                    sLogger.warn("Cannot recycle rtp packet, creating new", e);
                }
            }
        }
        RtpPacketImpl p = new RtpPacketImpl(dataSize){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void recycle() {
                ListHead listHead = JOrtpFactory.this.mRecycledPackets;
                synchronized (listHead) {
                    JOrtpFactory.this.mRecycledPackets.pushBack(this);
                }
            }
        };
        return p;
    }

    public PayloadType createPayloadType() {
        return new PayloadTypeImpl(null, null, 0, 0);
    }

    public RtpProfile createRtpProfile() {
        return new RtpProfileImpl();
    }

    public RtpProfile createRfc3551Profile() {
        return RtpProfileImpl.createAVProfile();
    }

    public RtpSession createRtpSession() {
        return new RtpSessionImpl();
    }

    public SocketAddress createSocketAddress(String host, int port) {
        return new SocketAddressImpl(host, port);
    }

    private JOrtpFactory() {
    }

    public RtpTransport createDefaultTransport() {
        try {
            Class<?> clasz = Class.forName("org.linphone.jortp.RtpJ2seTransport");
            return (RtpTransport)clasz.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Class.forName("org.linphone.jortp.RtpBBTransport");
                return (RtpTransport)clazz.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException("Cannot find rtp transport ");
            }
        }
    }
}

