/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.sal.jsr180;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.linphone.jlinphone.sal.jsr180.SalImpl;
import org.linphone.jlinphone.sal.jsr180.SdpUtils;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.sal.OfferAnswerHelper;
import org.linphone.sal.Sal;
import org.linphone.sal.SalAddress;
import org.linphone.sal.SalAuthInfo;
import org.linphone.sal.SalError;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalListener;
import org.linphone.sal.SalMediaDescription;
import org.linphone.sal.SalOpBase;
import org.linphone.sal.SalReason;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpFactory;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.SessionDescription;
import sip4me.gov.nist.microedition.sip.SipConnector;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipClientConnectionListener;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipException;
import sip4me.nist.javax.microedition.sip.SipHeader;
import sip4me.nist.javax.microedition.sip.SipRefreshHelper;
import sip4me.nist.javax.microedition.sip.SipRefreshListener;
import sip4me.nist.javax.microedition.sip.SipServerConnection;

class SalOpImpl
extends SalOpBase
implements SipRefreshListener {
    static Logger mLog = JOrtpFactory.instance().createLogger("Sal");
    SalAuthInfo mAuthInfo;
    SipClientConnection mClientCnx;
    SipServerConnection mInviteServerTransaction;
    final SipConnectionNotifier mConnectionNotifier;
    SalMediaDescription mLocalSalMediaDescription;
    SalMediaDescription mFinalSalMediaDescription;
    final SalListener mSalListener;
    SipDialog mDialog;
    static final int REGISTER_REFRES_HID_NOT_SET = -1;
    int mRegisterRefreshId = -1;

    public SalOpImpl(Sal sal, SipConnectionNotifier aConnectionNotifier, SalListener aSalListener) {
        super(sal);
        this.mConnectionNotifier = aConnectionNotifier;
        this.mSalListener = aSalListener;
    }

    public SalOpImpl(Sal sal, SipConnectionNotifier aConnectionNotifier, SalListener aSalListener, SipServerConnection aServerInviteTransaction) {
        this(sal, aConnectionNotifier, aSalListener);
        this.mInviteServerTransaction = aServerInviteTransaction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticate(SalAuthInfo info) throws SalException {
        this.mAuthInfo = info;
        try {
            if (this.mClientCnx != null) {
                if (info == null) throw new Exception("Bad auth info [" + info + "]");
                this.mClientCnx.setCredentials(info.getUserid(), info.getPassword(), info.getRealm());
                return;
            } else {
                mLog.warn("no registrar connection ready yet");
            }
            return;
        }
        catch (Exception e) {
            throw new SalException("Cannot authenticate", e);
        }
    }

    public void register(String proxy, String from, int expires) throws SalException {
        this.setFrom(from);
        this.setTo(from);
        this.setRoute(proxy);
        try {
            final SalAddress lAddress = SalFactory.instance().createSalAddress(from);
            this.mClientCnx = (SipClientConnection)SipConnector.open(lAddress.asStringUriOnly());
            this.mClientCnx.initRequest("REGISTER", this.mConnectionNotifier);
            this.mClientCnx.setHeader("From", from);
            this.mClientCnx.setHeader("Expires", String.valueOf(expires));
            if (proxy != null && proxy.length() > 0) {
                this.mClientCnx.setHeader("Route", this.getRouteHeaderValue(proxy));
            }
            String contactHdr = "sip:" + lAddress.getUserName() + "@" + this.getSal().getLocalAddr() + ":" + this.getSal().getLocalPort();
            this.mClientCnx.setHeader("Contact", contactHdr);
            this.mClientCnx.setRequestURI("sip:" + lAddress.getDomain());
            this.mClientCnx.setListener(new SipClientConnectionListener(){
                boolean mAuthSucceded = false;

                public void notifyResponse(SipClientConnection scc) {
                    try {
                        scc.receive(0L);
                        SipHeader lViaHeader = new SipHeader("Via", scc.getHeader("Via"));
                        if (lViaHeader.getParameter("received") != null) {
                            ((SalImpl)SalOpImpl.this.getSal()).setPublicLocalAddress(lViaHeader.getParameter("received"));
                        }
                        if (lViaHeader.getParameter("rport") != null) {
                            ((SalImpl)SalOpImpl.this.getSal()).setPublicLocalPort(Integer.parseInt(lViaHeader.getParameter("rport")));
                        }
                        switch (scc.getStatusCode()) {
                            case 401: 
                            case 407: {
                                if (!this.mAuthSucceded) {
                                    SipHeader lAuthHeader = SalOpImpl.this.getAuthHeader(scc);
                                    if (lAuthHeader != null) {
                                        SalOpImpl.this.mSalListener.onAuthRequested(SalOpImpl.this, lAuthHeader.getParameter("realm"), lAddress.getUserName());
                                        break;
                                    }
                                    mLog.error("Cannot get authentication header");
                                }
                                break;
                            }
                            case 200: {
                                if (!this.mAuthSucceded && SalOpImpl.this.getAuthInfo() != null) {
                                    SalOpImpl.this.mSalListener.onAuthSuccess(SalOpImpl.this, SalOpImpl.this.getAuthInfo().getRealm(), SalOpImpl.this.getAuthInfo().getUsername());
                                    this.mAuthSucceded = true;
                                }
                                SalOpImpl.this.mSalListener.OnRegisterSuccess(SalOpImpl.this, true);
                                break;
                            }
                            default: {
                                if (scc.getStatusCode() >= 500) {
                                    SalOpImpl.this.mSalListener.OnRegisterFailure(SalOpImpl.this, SalError.Failure, SalReason.Unknown, scc.getReasonPhrase());
                                    break;
                                }
                                mLog.error("Unexpected answer [" + scc + "]");
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        mLog.error("Cannot process REGISTER answer", e);
                    }
                }
            });
            if (expires > 0) {
                this.mRegisterRefreshId = this.mClientCnx.enableRefresh(this);
            }
            this.mClientCnx.send();
            mLog.info("REGISTER sent from [" + lAddress + "] to [" + proxy + "]");
        }
        catch (Throwable e) {
            throw new SalException("cannot send register  from [" + from + "] to [" + proxy + "]", e);
        }
    }

    public void call() throws SalException {
        try {
            SalAddress lToAddress = SalFactory.instance().createSalAddress(this.getTo());
            this.mClientCnx = (SipClientConnection)SipConnector.open(lToAddress.asStringUriOnly());
            this.mClientCnx.initRequest("INVITE", this.mConnectionNotifier);
            this.mClientCnx.setHeader("From", this.getFrom());
            this.mClientCnx.setRequestURI(lToAddress.asStringUriOnly());
            this.mClientCnx.setHeader("Content-Type", "application/sdp");
            if (this.getRoute() != null && this.getRoute().length() > 0) {
                this.mClientCnx.setHeader("Route", this.getRouteHeaderValue(this.getRoute()));
            }
            final SalAddress lFromAddress = SalFactory.instance().createSalAddress(this.getFrom());
            String contactHdr = "sip:" + lFromAddress.getUserName() + "@" + this.getSal().getLocalAddr() + ":" + this.getSal().getLocalPort();
            this.mClientCnx.setHeader("Contact", contactHdr);
            if (this.mAuthInfo != null) {
                this.mClientCnx.setCredentials(this.mAuthInfo.getUserid(), this.mAuthInfo.getPassword(), this.mAuthInfo.getRealm());
            }
            String lSdp = this.mLocalSalMediaDescription.toString();
            this.mClientCnx.setHeader("Content-Length", String.valueOf(lSdp.length()));
            this.mClientCnx.openContentOutputStream().write(lSdp.getBytes("US-ASCII"));
            this.mClientCnx.setListener(new SipClientConnectionListener(){

                private void computeFinalSalMediaDesc() throws SipException, IOException, SdpParseException, SdpException, SalException {
                    InputStream lSdpInputStream = SalOpImpl.this.mClientCnx.openContentInputStream();
                    byte[] lRawSdp = new byte[lSdpInputStream.available()];
                    lSdpInputStream.read(lRawSdp);
                    SessionDescription lSessionDescription = SdpFactory.getInstance().createSessionDescription(new String(lRawSdp));
                    SalMediaDescription lRemote = SdpUtils.toSalMediaDescription(lSessionDescription);
                    SalOpImpl.this.mFinalSalMediaDescription = OfferAnswerHelper.computeOutgoing(SalOpImpl.this.mLocalSalMediaDescription, lRemote);
                }

                public void notifyResponse(SipClientConnection scc) {
                    try {
                        scc.receive(0L);
                        switch (scc.getStatusCode()) {
                            case 200: {
                                this.computeFinalSalMediaDesc();
                                SalOpImpl.this.mDialog = SalOpImpl.this.mClientCnx.getDialog();
                                SalOpImpl.this.mClientCnx.initAck();
                                SalOpImpl.this.mClientCnx.send();
                                SalOpImpl.this.mSalListener.onCallAccepted(SalOpImpl.this);
                                break;
                            }
                            case 183: {
                                if (SalOpImpl.this.mFinalSalMediaDescription != null) break;
                                this.computeFinalSalMediaDesc();
                            }
                            case 180: {
                                SalOpImpl.this.mSalListener.onCallRinging(SalOpImpl.this);
                                break;
                            }
                            case 401: 
                            case 407: {
                                if (SalOpImpl.this.mAuthInfo == null) {
                                    SipHeader lAuthHeader = SalOpImpl.this.getAuthHeader(scc);
                                    if (lAuthHeader != null) {
                                        SalOpImpl.this.mSalListener.onAuthRequested(SalOpImpl.this, lAuthHeader.getParameter("realm"), lFromAddress.getUserName());
                                        break;
                                    }
                                    SalOpImpl.this.mSalListener.onCallFailure(SalOpImpl.this, "Cannot find Auth info from sip message");
                                }
                                break;
                            }
                            case 487: {
                                break;
                            }
                            default: {
                                if (scc.getStatusCode() > 300) {
                                    SalOpImpl.this.mSalListener.onCallFailure(SalOpImpl.this, scc.getReasonPhrase());
                                    break;
                                }
                                mLog.warn("Unexpected answer [" + scc.getStatusCode() + " " + scc.getRequestURI() + "]");
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        mLog.error("cannot handle invite answer", e);
                        SalOpImpl.this.mSalListener.onCallFailure(SalOpImpl.this, e.getMessage());
                    }
                }
            });
            this.mClientCnx.send();
            ((SalImpl)this.getSal()).setIncallOp(this);
        }
        catch (Throwable e) {
            throw new SalException(e);
        }
    }

    public void callAccept() throws SalException {
        try {
            SessionDescription lSessionDescription;
            InputStream lSdpInputStream = this.mInviteServerTransaction.openContentInputStream();
            byte[] lRawSdp = new byte[lSdpInputStream.available()];
            lSdpInputStream.read(lRawSdp);
            try {
                lSessionDescription = SdpFactory.getInstance().createSessionDescription(new String(lRawSdp));
            }
            catch (SdpParseException e) {
                throw new SalException("Parser error, cannot parse incoming sdp", e);
            }
            SalMediaDescription lRemote = SdpUtils.toSalMediaDescription(lSessionDescription);
            OfferAnswerHelper.AnswerResult lAnswerResult = OfferAnswerHelper.computeIncoming(this.mLocalSalMediaDescription, lRemote);
            if (lAnswerResult.getResult().getNumStreams() == 0) {
                mLog.warn("No codec matching");
                this.mInviteServerTransaction.initResponse(404);
                this.mInviteServerTransaction.send();
                this.mSalListener.onCallFailure(this, "no matching codecs");
            } else {
                this.mFinalSalMediaDescription = lAnswerResult.getResult();
                this.mInviteServerTransaction.initResponse(200);
                this.mInviteServerTransaction.setHeader("Content-Type", "application/sdp");
                String lSdp = lAnswerResult.getAnswer().toString();
                this.mInviteServerTransaction.setHeader("Content-Length", String.valueOf(lSdp.length()));
                this.mInviteServerTransaction.openContentOutputStream().write(lSdp.getBytes("US-ASCII"));
                this.mInviteServerTransaction.send();
                this.mDialog = this.mInviteServerTransaction.getDialog();
            }
        }
        catch (Throwable e) {
            throw new SalException(e);
        }
    }

    public void callDecline(Sal.Reason r, String redirectUri) {
        if (this.mInviteServerTransaction != null) {
            try {
                int lReason = r == Sal.Reason.Busy ? 486 : (r == Sal.Reason.Declined ? 603 : 603);
                this.mInviteServerTransaction.initResponse(lReason);
                this.mInviteServerTransaction.send();
                this.mSalListener.onCallTerminated(this);
                this.mInviteServerTransaction = null;
            }
            catch (Throwable e) {
                mLog.error("cannot cancel call", e);
            }
        }
    }

    public void callSetLocalMediaDescription(SalMediaDescription md) {
        this.mLocalSalMediaDescription = md;
    }

    public void callTerminate() {
        try {
            try {
                if (this.mDialog != null) {
                    SipClientConnection lByeConnection = this.mDialog.getNewClientConnection("BYE");
                    lByeConnection.send();
                } else if (this.mClientCnx != null) {
                    SipClientConnection lSipCancelCnx = this.mClientCnx.initCancel();
                    lSipCancelCnx.send();
                }
            }
            catch (Throwable e) {
                mLog.error("cannot terminate call", e);
                this.mSalListener.onCallTerminated(this);
                ((SalImpl)this.getSal()).setIncallOp(null);
            }
        }
        finally {
            this.mSalListener.onCallTerminated(this);
            ((SalImpl)this.getSal()).setIncallOp(null);
        }
    }

    public SalAuthInfo getAuthInfo() {
        return this.mAuthInfo;
    }

    public SalMediaDescription getFinalMediaDescription() {
        return this.mFinalSalMediaDescription;
    }

    public void callRinging() throws SalException {
        try {
            if (this.mInviteServerTransaction == null) {
                throw new SalException("no in a proper state");
            }
            this.mInviteServerTransaction.initResponse(180);
            this.mInviteServerTransaction.send();
        }
        catch (Throwable e) {
            throw new SalException(e);
        }
    }

    public void refreshEvent(int refreshID, int statusCode, String reasonPhrase) {
    }

    private SipHeader getAuthHeader(SipClientConnection scc) {
        SipHeader lAuthHeader = null;
        if (scc.getHeader("Proxy-Authenticate") != null) {
            lAuthHeader = new SipHeader("Authorization", scc.getHeader("Proxy-Authenticate"));
        } else if (scc.getHeader("WWW-Authenticate") != null) {
            lAuthHeader = new SipHeader("WWW-Authenticate", scc.getHeader("WWW-Authenticate"));
        }
        return lAuthHeader;
    }

    public void unregister() {
        if (this.mClientCnx != null) {
            try {
                SipRefreshHelper.getInstance().stop(this.mRegisterRefreshId);
            }
            catch (Throwable e) {
                mLog.error("Cannot unregister", e);
            }
        } else {
            mLog.error("not register");
        }
    }

    public void notifyRequestReceived(SipServerConnection cnx) {
        try {
            if ("BYE".equals(cnx.getMethod()) || "CANCEL".equals(cnx.getMethod())) {
                this.mSalListener.onCallTerminated(this);
                cnx.initResponse(200);
                cnx.send();
                if ("CANCEL".equals(cnx.getMethod()) && this.mInviteServerTransaction != null) {
                    this.mInviteServerTransaction.initResponse(487);
                    this.mInviteServerTransaction.send();
                }
                ((SalImpl)this.getSal()).setIncallOp(null);
            } else {
                cnx.initResponse(500);
                cnx.send();
            }
        }
        catch (Throwable e) {
            mLog.error("Cannot answer to : " + cnx.getMethod() + " " + cnx.getRequestURI(), e);
        }
    }

    private String getRouteHeaderValue(String proxy) {
        String lRouteHeaderValue = proxy;
        if (this.getSal().getTransport() != null && this.getSal().getTransport() == Sal.Transport.Stream) {
            SalAddress lProxy = SalFactory.instance().createSalAddress(proxy);
            if (lProxy.getTransport() == null) {
                lProxy.setTransport(Sal.Transport.Stream);
            }
            lRouteHeaderValue = lProxy.asStringUriOnly();
        }
        return String.valueOf(lRouteHeaderValue) + ";lr";
    }

    public void sendDtmf(char number) {
        mLog.info("sending dtmf [" + number + "]");
        try {
            if (this.mDialog != null) {
                SipClientConnection lInfoConnection = this.mDialog.getNewClientConnection("INFO");
                lInfoConnection.setHeader("Content-Type", "application/dtmf-relay");
                String ldtmf = new String("Signal=" + number + "\r\nDuration=250\r\n");
                lInfoConnection.setHeader("Content-Length", String.valueOf(ldtmf.length()));
                OutputStream lDtmfOutputStream = lInfoConnection.openContentOutputStream();
                lDtmfOutputStream.write(ldtmf.getBytes("US-ASCII"));
                lInfoConnection.send();
            }
        }
        catch (Throwable e) {
            mLog.error("cannot send dtmf [" + number + "]", e);
        }
    }
}

