/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.gui;

import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.Display;
import net.rim.device.api.ui.ContextMenu;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ListFieldCallback;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCallLog;
import org.linphone.core.LinphoneCore;
import org.linphone.jlinphone.gui.LinphoneResource;
import org.linphone.jlinphone.gui.SelectableListField;
import org.linphone.jlinphone.gui.TabFieldItem;

public class CallLogsField
extends SelectableListField
implements TabFieldItem,
LinphoneResource {
    final LinphoneCore mCore;
    private static ResourceBundle mRes = ResourceBundle.getBundle((long)-8981235513634632902L, (String)"org.linphone.jlinphone.gui.Linphone");
    MenuItem mClearMenu;
    boolean isViewable = false;

    CallLogsField(LinphoneCore aCore, SelectableListField.Listener aListener) {
        super(aListener);
        this.mCore = aCore;
        final Bitmap lOutBitmap = new Bitmap(this.getRowHeight(), this.getRowHeight());
        lOutBitmap.createAlpha(1);
        Bitmap.getBitmapResource((String)"out_call.png").scaleInto(lOutBitmap, 0);
        final Bitmap lInBitmap = new Bitmap(this.getRowHeight(), this.getRowHeight());
        lInBitmap.createAlpha(1);
        Bitmap.getBitmapResource((String)"in_call.png").scaleInto(lInBitmap, 0);
        this.mClearMenu = new MenuItem(mRes.getString(23), 110, 10){

            public void run() {
                CallLogsField.this.mCore.clearCallLogs();
                CallLogsField.this.refresh();
                CallLogsField.this.invalidate();
            }
        };
        this.setCallback(new ListFieldCallback(){

            public void drawListRow(ListField list, Graphics g, int index, int y, int w) {
                LinphoneAddress lAddressToDisplay;
                if (list.getSelectedIndex() != index) {
                    g.setBackgroundColor(index % 2 == 0 ? 0xD3D3D3 : 0xA9A9A9);
                    g.clear();
                }
                int lXCurrentPosistion = 0;
                LinphoneCallLog lCallLog = (LinphoneCallLog)this.get(list, index);
                if (lCallLog.getDirection() == CallDirection.Incoming) {
                    g.drawBitmap(0, y, lInBitmap.getWidth(), lInBitmap.getHeight(), lInBitmap, 0, 0);
                    lAddressToDisplay = lCallLog.getFrom();
                } else {
                    g.drawBitmap(0, y, lOutBitmap.getWidth(), lOutBitmap.getHeight(), lOutBitmap, 0, 0);
                    lAddressToDisplay = lCallLog.getTo();
                }
                lXCurrentPosistion = lInBitmap.getWidth() + 5;
                if (lAddressToDisplay.getDisplayName() != null) {
                    g.setFont(Font.getDefault().derive(1));
                    g.drawText(lAddressToDisplay.getDisplayName(), lXCurrentPosistion, y, 0, w);
                    lXCurrentPosistion += g.getFont().getAdvance(lAddressToDisplay.getDisplayName()) + g.getFont().getAdvance(" ");
                    g.setFont(Font.getDefault());
                }
                g.drawText(lAddressToDisplay != null ? lAddressToDisplay.getUserName() : "unknown", lXCurrentPosistion, y, 0, w);
            }

            public Object get(ListField list, int index) {
                return CallLogsField.this.mCore.getCallLogs().elementAt(this.getLenth() - index - 1);
            }

            public int indexOfList(ListField list, String prefix, int string) {
                return CallLogsField.this.mCore.getCallLogs().indexOf(prefix, string);
            }

            public int getPreferredWidth(ListField list) {
                return Display.getWidth();
            }

            private int getLenth() {
                return CallLogsField.this.mCore.getCallLogs().size();
            }
        });
        this.refresh();
    }

    public void refresh() {
        this.setSize(this.mCore.getCallLogs().size());
    }

    public void onSelected() {
        this.refresh();
    }

    public void onUnSelected() {
    }

    protected void makeContextMenu(ContextMenu contextMenu) {
        super.makeContextMenu(contextMenu);
        contextMenu.addItem(this.mClearMenu);
    }

    public boolean keyChar(char ch, int status, int time) {
        return super.keyChar(ch, status, time);
    }
}

