/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import java.util.Calendar;
import java.util.Vector;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.header.AuthorizationHeader;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContentLengthHeader;
import sip4me.gov.nist.siplite.header.ContentTypeHeader;
import sip4me.gov.nist.siplite.header.DateHeader;
import sip4me.gov.nist.siplite.header.EventHeader;
import sip4me.gov.nist.siplite.header.ExpiresHeader;
import sip4me.gov.nist.siplite.header.ExtensionHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.HeaderList;
import sip4me.gov.nist.siplite.header.MaxForwardsHeader;
import sip4me.gov.nist.siplite.header.NameMap;
import sip4me.gov.nist.siplite.header.ProxyAuthenticateHeader;
import sip4me.gov.nist.siplite.header.ProxyAuthorizationHeader;
import sip4me.gov.nist.siplite.header.RecordRouteHeader;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.WWWAuthenticateHeader;
import sip4me.gov.nist.siplite.parser.StringMsgParser;

public class HeaderFactory {
    public AuthorizationHeader createAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null arg scheme ");
        }
        AuthorizationHeader auth = new AuthorizationHeader();
        auth.setScheme(scheme);
        return auth;
    }

    public CSeqHeader createCSeqHeader(int sequenceNumber, String method) throws ParseException, IllegalArgumentException {
        if (sequenceNumber < 0) {
            throw new IllegalArgumentException("bad arg " + sequenceNumber);
        }
        if (method == null) {
            throw new NullPointerException("null arg method");
        }
        CSeqHeader cseq = new CSeqHeader();
        cseq.setMethod(method);
        cseq.setSequenceNumber(sequenceNumber);
        return cseq;
    }

    public CallIdHeader createCallId(String callId) throws ParseException {
        if (callId == null) {
            throw new NullPointerException("null arg callId");
        }
        CallIdHeader c = new CallIdHeader();
        c.setCallId(callId);
        return c;
    }

    public ContactHeader createContactHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null arg address");
        }
        ContactHeader contact = new ContactHeader();
        contact.setAddress(address);
        return contact;
    }

    public ContactHeader createContactHeader() {
        ContactHeader contact = new ContactHeader();
        contact.setWildCardFlag(true);
        contact.setExpires(0);
        return contact;
    }

    public ContentLengthHeader createContentLengthHeader(int contentLength) throws IllegalArgumentException {
        if (contentLength < 0) {
            throw new IllegalArgumentException("bad contentLength");
        }
        ContentLengthHeader c = new ContentLengthHeader();
        c.setContentLength(contentLength);
        return c;
    }

    public ContentTypeHeader createContentTypeHeader(String contentType, String contentSubType) throws ParseException {
        if (contentType == null || contentSubType == null) {
            throw new NullPointerException("null contentType or subType");
        }
        ContentTypeHeader c = new ContentTypeHeader();
        c.setContentType(contentType);
        c.setContentSubType(contentSubType);
        return c;
    }

    public DateHeader createDateHeader(Calendar date) {
        DateHeader d = new DateHeader();
        if (date == null) {
            throw new NullPointerException("null date");
        }
        d.setDate(date);
        return d;
    }

    public EventHeader createEventHeader(String eventType) throws ParseException {
        if (eventType == null) {
            throw new NullPointerException("null eventType");
        }
        EventHeader event = new EventHeader();
        event.setEventType(eventType);
        return event;
    }

    public ExpiresHeader createExpiresHeader(int expires) throws IllegalArgumentException {
        if (expires < 0) {
            throw new IllegalArgumentException("bad value " + expires);
        }
        ExpiresHeader e = new ExpiresHeader();
        e.setExpires(expires);
        return e;
    }

    public ExtensionHeader createExtensionHeader(String name, String value) throws ParseException {
        if (name == null) {
            throw new NullPointerException("bad name");
        }
        ExtensionHeader ext = new ExtensionHeader();
        ext.setHeaderName(name);
        ext.setValue(value);
        return ext;
    }

    public FromHeader createFromHeader(Address address, String tag) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        FromHeader from = new FromHeader();
        from.setAddress(address);
        if (tag != null) {
            from.setTag(tag);
        }
        return from;
    }

    public MaxForwardsHeader createMaxForwardsHeader(int maxForwards) throws IllegalArgumentException {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new IllegalArgumentException("bad maxForwards arg " + maxForwards);
        }
        MaxForwardsHeader m = new MaxForwardsHeader();
        m.setMaxForwards(maxForwards);
        return m;
    }

    public ProxyAuthenticateHeader createProxyAuthenticateHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthenticateHeader p = new ProxyAuthenticateHeader();
        p.setScheme(scheme);
        return p;
    }

    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthorizationHeader p = new ProxyAuthorizationHeader();
        p.setScheme(scheme);
        return p;
    }

    public RecordRouteHeader createRecordRouteHeader(Address address) {
        RecordRouteHeader recordRouteHeader = new RecordRouteHeader();
        recordRouteHeader.setAddress(address);
        return recordRouteHeader;
    }

    public RouteHeader createRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        RouteHeader route = new RouteHeader();
        route.setAddress(address);
        return route;
    }

    public ToHeader createToHeader(Address address, String tag) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        ToHeader to = new ToHeader();
        to.setAddress(address);
        if (tag != null) {
            to.setTag(tag);
        }
        return to;
    }

    public ViaHeader createViaHeader(String host, int port, String transport, String branch) throws ParseException {
        if (host == null || transport == null) {
            throw new NullPointerException("null arg");
        }
        ViaHeader via = new ViaHeader();
        if (branch != null) {
            via.setBranch(branch);
        }
        via.setHost(host);
        via.setPort(port);
        via.setTransport(transport);
        return via;
    }

    public WWWAuthenticateHeader createWWWAuthenticateHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null scheme");
        }
        WWWAuthenticateHeader www = new WWWAuthenticateHeader();
        www.setScheme(scheme);
        return www;
    }

    public Header createHeader(String headerName, String headerValue) throws ParseException {
        if (headerName == null) {
            throw new NullPointerException("header name is null");
        }
        String hdrText = headerName + ":" + headerValue;
        Class clazz = NameMap.getClassFromName(headerName);
        if (clazz == null) {
            ExtensionHeader retval = new ExtensionHeader();
            retval.setHeaderName(headerName);
            retval.setValue(headerValue);
            return retval;
        }
        try {
            if (headerValue == null) {
                Header retval = (Header)clazz.newInstance();
                retval.setHeaderName(headerName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InternalErrorHandler.handleException(ex);
            return null;
        }
        StringMsgParser smp = new StringMsgParser();
        Header sipHeader = smp.parseHeader(hdrText);
        if (sipHeader instanceof HeaderList) {
            if (((HeaderList)sipHeader).size() > 1) {
                throw new ParseException("Only singleton allowed !", 0);
            }
            return (Header)((HeaderList)sipHeader).first();
        }
        return sipHeader;
    }

    public Vector createHeaders(String headers) throws ParseException {
        if (headers == null) {
            throw new NullPointerException("null arg!");
        }
        StringMsgParser smp = new StringMsgParser();
        Header shdr = smp.parseHeader(headers);
        if (shdr instanceof HeaderList) {
            return ((HeaderList)shdr).getHeaders();
        }
        throw new ParseException("List of headers of this type is not allowed in a message", 0);
    }
}

