/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.header.AddressParametersHeader;

public final class ContactHeader
extends AddressParametersHeader {
    public static Class clazz = new ContactHeader().getClass();
    public static final String NAME = "Contact";
    protected boolean wildCardFlag = false;
    protected String comment;

    public ContactHeader() {
        super(NAME);
    }

    public String encodeBody() {
        String encoding = "";
        if (this.wildCardFlag) {
            return String.valueOf(encoding) + "*";
        }
        if (this.address != null) {
            encoding = this.address.getAddressType() == 1 ? String.valueOf(encoding) + this.address.encode() : String.valueOf(encoding) + "<" + this.address.encode() + ">";
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            encoding = String.valueOf(encoding) + ";" + this.parameters.encode();
        }
        if (this.comment != null) {
            encoding = String.valueOf(encoding) + "(" + this.comment + ")";
        }
        return encoding;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    public String getAction() {
        return this.getParameter("action");
    }

    public Object getValue() {
        return this.address;
    }

    public String getComment() {
        return this.comment;
    }

    public String getExpires() {
        return this.getParameter("expires");
    }

    public void setExpires(String expires) {
        this.setParameter("expires", expires);
    }

    public void setExpires(int expires) {
        this.setParameter("expires", new Integer(expires).toString());
    }

    public String getQValue() {
        return this.getParameter("q");
    }

    public boolean hasQValue() {
        return this.hasParameter("q");
    }

    public void setWildCardFlag(boolean w) {
        this.wildCardFlag = w;
    }

    public void setAddress(Address address) {
        if (address != null) {
            this.address = address;
        }
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.comment = comment;
        }
    }

    public Object clone() {
        ContactHeader retval = new ContactHeader();
        retval.wildCardFlag = this.wildCardFlag;
        if (this.comment != null) {
            retval.comment = new String(this.comment);
        }
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        if (this.address != null) {
            retval.address = (Address)this.address.clone();
        }
        return retval;
    }
}

