/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.parser;

import java.util.Vector;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.ParserCore;
import sip4me.gov.nist.javax.sdp.SessionDescription;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.parser.Lexer;
import sip4me.gov.nist.javax.sdp.parser.ParserFactory;
import sip4me.gov.nist.javax.sdp.parser.SDPParser;

public class SDPAnnounceParser
extends ParserCore {
    protected Lexer lexer;
    protected Vector sdpMessage;

    public SDPAnnounceParser(Vector sdpMessage) {
        this.sdpMessage = sdpMessage;
    }

    public SDPAnnounceParser(String message) {
        if (message == null) {
            return;
        }
        int start = 0;
        this.sdpMessage = new Vector();
        String sdpAnnounce = String.valueOf(message.trim()) + "\r\n";
        while (start < sdpAnnounce.length()) {
            int add = 0;
            int index = sdpAnnounce.indexOf("\n", start);
            if (index == -1) break;
            if (sdpAnnounce.charAt(index - 1) == '\r') {
                --index;
                add = 1;
            }
            String line = sdpAnnounce.substring(start, index);
            start = index + 1 + add;
            this.sdpMessage.addElement(line);
        }
    }

    public SessionDescription parse() throws ParseException {
        SessionDescription retval = new SessionDescription();
        int i = 0;
        while (i < this.sdpMessage.size()) {
            String field = (String)this.sdpMessage.elementAt(i);
            SDPParser sdpParser = ParserFactory.createParser(field);
            SDPField sdpField = sdpParser.parse();
            retval.addField(sdpField);
            ++i;
        }
        return retval;
    }
}

