/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp;

import java.util.Vector;
import sip4me.gov.nist.core.NameValue;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.AttributeField;
import sip4me.gov.nist.javax.sdp.fields.BandwidthField;
import sip4me.gov.nist.javax.sdp.fields.ConnectionField;
import sip4me.gov.nist.javax.sdp.fields.InformationField;
import sip4me.gov.nist.javax.sdp.fields.KeyField;
import sip4me.gov.nist.javax.sdp.fields.MediaField;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class MediaDescription {
    protected MediaField mediaField;
    protected InformationField informationField;
    protected ConnectionField connectionField;
    protected Vector bandwidthFields = new Vector();
    protected KeyField keyField;
    protected Vector attributeFields = new Vector();

    public String encode() {
        int i;
        StringBuffer retval = new StringBuffer();
        if (this.mediaField != null) {
            retval.append(this.mediaField.encode());
        }
        if (this.informationField != null) {
            retval.append(this.informationField.encode());
        }
        if (this.connectionField != null) {
            retval.append(this.connectionField.encode());
        }
        if (this.bandwidthFields != null) {
            i = 0;
            while (i < this.bandwidthFields.size()) {
                BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
                retval.append(bandwidthField.encode());
                ++i;
            }
        }
        if (this.keyField != null) {
            retval.append(this.keyField.encode());
        }
        if (this.attributeFields != null) {
            i = 0;
            while (i < this.attributeFields.size()) {
                retval.append(((SDPField)this.attributeFields.elementAt(i)).encode());
                ++i;
            }
        }
        return retval.toString();
    }

    public String toString() {
        return this.encode();
    }

    public MediaField getMediaField() {
        return this.mediaField;
    }

    public InformationField getInformationField() {
        return this.informationField;
    }

    public ConnectionField getConnectionField() {
        return this.connectionField;
    }

    public KeyField getKeyField() {
        return this.keyField;
    }

    public Vector getAttributeFields() {
        return this.attributeFields;
    }

    public void setMediaField(MediaField m) {
        this.mediaField = m;
    }

    public void setInformationField(InformationField i) {
        this.informationField = i;
    }

    public void setConnectionField(ConnectionField c) {
        this.connectionField = c;
    }

    public void addBandwidthField(BandwidthField b) {
        this.bandwidthFields.addElement(b);
    }

    public void setKeyField(KeyField k) {
        this.keyField = k;
    }

    public void setAttributeFields(Vector a) {
        this.attributeFields = a;
    }

    public MediaField getMedia() {
        return this.mediaField;
    }

    public void addAttribute(AttributeField af) {
        this.attributeFields.addElement(af);
    }

    protected boolean hasAttribute(String name) {
        int i = 0;
        while (i < this.attributeFields.size()) {
            AttributeField af = (AttributeField)this.attributeFields.elementAt(i);
            if (af.getAttribute().getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setMedia(MediaField media) throws SdpException {
        if (media == null) {
            throw new SdpException("The media is null");
        }
        this.mediaField = media;
    }

    public InformationField getInfo() {
        return this.informationField;
    }

    public void setInfo(InformationField i) throws SdpException {
        if (i == null) {
            throw new SdpException("The info is null");
        }
        this.informationField = i;
    }

    public ConnectionField getConnection() {
        return this.connectionField;
    }

    public void setConnection(ConnectionField conn) throws SdpException {
        if (conn == null) {
            throw new SdpException("The conn is null");
        }
        this.connectionField = conn;
    }

    public Vector getBandwidths(boolean create) {
        return this.bandwidthFields;
    }

    public void setBandwidths(Vector bandwidths) throws SdpException {
        if (bandwidths == null) {
            throw new SdpException("The vector bandwidths is null");
        }
        this.bandwidthFields = bandwidths;
    }

    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            throw new NullPointerException("null parameter");
        }
        if (this.bandwidthFields == null) {
            return -1;
        }
        int i = 0;
        while (i < this.bandwidthFields.size()) {
            BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
            String type = bandwidthField.getBwtype();
            if (type != null && type.equals(name)) {
                return bandwidthField.getBandwidth();
            }
            ++i;
        }
        return -1;
    }

    public void setBandwidth(String name, int value) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        int i = 0;
        while (i < this.bandwidthFields.size()) {
            BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
            String type = bandwidthField.getBwtype();
            if (type != null && type.equals(name)) {
                bandwidthField.setBandwidth(value);
            }
            ++i;
        }
    }

    public void removeBandwidth(String name) {
        if (name == null) {
            throw new NullPointerException("null bandwidth type");
        }
        int i = 0;
        i = 0;
        while (i < this.bandwidthFields.size()) {
            BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
            String type = bandwidthField.getBwtype();
            if (type != null && type.equals(name)) break;
            ++i;
        }
        if (i < this.bandwidthFields.size()) {
            this.bandwidthFields.removeElementAt(i);
        }
    }

    public KeyField getKey() {
        return this.keyField;
    }

    public void setKey(KeyField key) throws SdpException {
        if (key == null) {
            throw new SdpException("The key is null");
        }
        this.setKeyField(key);
    }

    public Vector getAttributes(boolean create) {
        return this.attributeFields;
    }

    public void setAttributes(Vector attributes) throws SdpException {
        this.attributeFields = attributes;
    }

    public String getAttribute(String name) throws SdpParseException {
        if (name != null) {
            int i = 0;
            while (i < this.attributeFields.size()) {
                AttributeField af = (AttributeField)this.attributeFields.elementAt(i);
                if (name.equals(af.getAttribute().getName())) {
                    return (String)af.getAttribute().getValue();
                }
                ++i;
            }
            return null;
        }
        throw new NullPointerException("null arg!");
    }

    public void setAttribute(String name, String value) throws SdpException {
        NameValue nv;
        AttributeField af;
        if (name == null) {
            throw new SdpException("The parameters are null");
        }
        int i = 0;
        i = 0;
        while (i < this.attributeFields.size()) {
            af = (AttributeField)this.attributeFields.elementAt(i);
            if (af.getAttribute().getName().equals(name)) {
                nv = af.getAttribute();
                nv.setValue(value);
                break;
            }
            ++i;
        }
        if (i == this.attributeFields.size()) {
            af = new AttributeField();
            nv = new NameValue(name, value);
            af.setAttribute(nv);
            this.attributeFields.addElement(af);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("null arg!");
        }
        if (name != null) {
            int i = 0;
            i = 0;
            while (i < this.attributeFields.size()) {
                AttributeField af = (AttributeField)this.attributeFields.elementAt(i);
                if (af.getAttribute().getName().equals(name)) break;
                ++i;
            }
            if (i < this.attributeFields.size()) {
                this.attributeFields.removeElementAt(i);
            }
        }
    }

    public Vector getMimeTypes() throws SdpException {
        MediaField mediaField = this.getMedia();
        String type = mediaField.getMediaType();
        String protocol = mediaField.getProtocol();
        Vector formats = mediaField.getMediaFormats(false);
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < formats.size()) {
            String result = null;
            if (protocol.equals("RTP/AVP")) {
                if (this.getAttribute("RTPMAP") != null) {
                    result = String.valueOf(type) + "/" + protocol;
                }
            } else {
                result = String.valueOf(type) + "/" + protocol;
            }
            v.addElement(result);
            ++i;
        }
        return v;
    }

    public Vector getMimeParameters() throws SdpException {
        String rate = this.getAttribute("rate");
        String ptime = this.getAttribute("ptime");
        String maxptime = this.getAttribute("maxptime");
        String ftmp = this.getAttribute("ftmp");
        Vector<String> result = new Vector<String>();
        result.addElement(rate);
        result.addElement(ptime);
        result.addElement(maxptime);
        result.addElement(ftmp);
        return result;
    }

    public void addDynamicPayloads(Vector payloadNames, Vector payloadValues) throws SdpException {
        MediaField mediaField = this.getMedia();
        if (payloadNames == null || payloadValues == null) {
            throw new SdpException(" The vectors are null");
        }
        if (payloadNames.isEmpty() || payloadValues.isEmpty()) {
            throw new SdpException(" The vectors are empty");
        }
        if (payloadNames.size() != payloadValues.size()) {
            throw new SdpException(" The vector sizes are unequal");
        }
        int i = 0;
        while (i < payloadNames.size()) {
            String name = (String)payloadNames.elementAt(i);
            String value = (String)payloadValues.elementAt(i);
            this.setAttribute(name, value);
            ++i;
        }
    }
}

