/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import java.util.Random;
import org.bouncycastle.crypto.digests.MD5Digest;

public class Utils {
    private static MD5Digest messageDigest = new MD5Digest();
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Random rnd = new Random(System.currentTimeMillis());
    private static final byte[] allowed_chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes();

    public static byte[] digest(byte[] digestBytes) {
        messageDigest.update(digestBytes, 0, digestBytes.length);
        byte[] retval = new byte[messageDigest.getDigestSize()];
        messageDigest.doFinal(retval, 0);
        return retval;
    }

    public static String generateTag() {
        return Utils.randomAlphanumericString(9);
    }

    public static int compareToIgnoreCase(String s1, String s2) {
        String su1 = s1.toUpperCase();
        String su2 = s2.toUpperCase();
        return su1.compareTo(su2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.toLowerCase().equals(s2.toLowerCase());
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        int i = 0;
        while (i < b.length) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
            ++i;
        }
        return new String(c);
    }

    public static String toHexString(long aLong) {
        byte[] bytes = new byte[8];
        bytes[7] = (byte)(aLong >>> 0 & 0xFFL);
        bytes[6] = (byte)(aLong >>> 8 & 0xFFL);
        bytes[5] = (byte)(aLong >>> 16 & 0xFFL);
        bytes[4] = (byte)(aLong >>> 24 & 0xFFL);
        bytes[3] = (byte)(aLong >>> 32 & 0xFFL);
        bytes[2] = (byte)(aLong >>> 40 & 0xFFL);
        bytes[1] = (byte)(aLong >>> 48 & 0xFFL);
        bytes[0] = (byte)(aLong >>> 56 & 0xFFL);
        return Utils.toHexString(bytes);
    }

    public static String toHexString(double aDouble) {
        return Utils.toHexString(Double.doubleToLongBits(aDouble));
    }

    public static String toHexString(int anInt) {
        byte[] b = new byte[4];
        b[3] = (byte)(anInt & 0xFF);
        b[2] = (byte)((anInt & 0xFF00) >> 8);
        b[1] = (byte)((anInt & 0xFF0000) >> 16);
        b[0] = (byte)((anInt & 0xFF000000) >> 24);
        return Utils.toHexString(b);
    }

    public static String getQuotedString(String str) {
        return String.valueOf('\"') + str + '\"';
    }

    public static String reduceString(String input) {
        String newString = input.toLowerCase();
        int len = newString.length();
        String retval = "";
        int i = 0;
        while (i < len) {
            if (newString.charAt(i) != ' ' && newString.charAt(i) != '\t') {
                retval = String.valueOf(retval) + newString.charAt(i);
            }
            ++i;
        }
        return retval;
    }

    public static String randomAlphanumericString(int length) {
        byte[] array = new byte[length];
        int i = 0;
        while (i < length) {
            array[i] = allowed_chars[rnd.nextInt(allowed_chars.length)];
            ++i;
        }
        return new String(array);
    }
}

