/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.core;

public final class VideoSize {
    public static final int QCIF = 0;
    public static final int CIF = 1;
    public static final int HVGA = 2;
    private int width;
    private int height;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public VideoSize() {
    }

    private VideoSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static final VideoSize createStandard(int code) {
        switch (code) {
            case 0: {
                return new VideoSize(176, 144);
            }
            case 1: {
                return new VideoSize(352, 288);
            }
            case 2: {
                return new VideoSize(320, 480);
            }
        }
        return new VideoSize();
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoSize other = (VideoSize)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }
}

