/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.core;

import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneAuthInfo;
import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.core.LinphoneCoreListener;
import org.linphone.core.LinphoneFriend;
import org.linphone.core.LinphoneLogHandler;
import org.linphone.core.LinphoneProxyConfig;

public abstract class LinphoneCoreFactory {
    private static String factoryName = "org.linphone.core.LinphoneCoreFactoryImpl";
    static LinphoneCoreFactory theLinphoneCoreFactory;

    public static void setFactoryClassName(String className) {
        factoryName = className;
    }

    public static LinphoneCoreFactory instance() {
        try {
            if (theLinphoneCoreFactory == null) {
                Class<?> lFactoryClass = Class.forName(factoryName);
                theLinphoneCoreFactory = (LinphoneCoreFactory)lFactoryClass.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("cannot instanciate factory [" + factoryName + "]");
        }
        return theLinphoneCoreFactory;
    }

    public abstract LinphoneAuthInfo createAuthInfo(String var1, String var2, String var3);

    public abstract LinphoneCore createLinphoneCore(LinphoneCoreListener var1, String var2, String var3, Object var4) throws LinphoneCoreException;

    public abstract LinphoneCore createLinphoneCore(LinphoneCoreListener var1) throws LinphoneCoreException;

    public abstract LinphoneAddress createLinphoneAddress(String var1, String var2, String var3);

    public abstract LinphoneAddress createLinphoneAddress(String var1);

    public abstract LinphoneProxyConfig createProxyConfig(String var1, String var2, String var3, boolean var4) throws LinphoneCoreException;

    public abstract void setDebugMode(boolean var1);

    public abstract void setLogHandler(LinphoneLogHandler var1);

    public abstract LinphoneFriend createLinphoneFriend(String var1);

    public abstract LinphoneFriend createLinphoneFriend();
}

