<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


// This database is resilient because it stores everything in the bare 
// filesystem. If one entry gets corrupted, the rest remains okay.


class Database_OfflineResources
{
  private static $instance;
  private function __construct() {
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_OfflineResources ();
    }
    return self::$instance;
  }


  private function mainFolder ()
  {
    $folder = realpath (__DIR__ . "/../databases/offlineresources");
    return $folder;
  }
  
  
  private function resourceFolder ($name)
  {
    $folder = $this->mainFolder () . "/$name";
    return $folder;
  }
  
  
  private function bookFolder ($name, $book)
  {
    $folder = $this->resourceFolder ($name) . "/$book";
    return $folder;
  }


  private function chapterFolder ($name, $book, $chapter)
  {
    $folder = $this->bookFolder ($name, $book) . "/$chapter";
    return $folder;
  }


  private function verseFile ($name, $book, $chapter, $verse)
  {
    $file = $this->chapterFolder ($name, $book, $chapter) . "/$verse";
    return $file;
  }


  public function delete ($name)
  {
    $folder = $this->resourceFolder ($name);
    Filter_Rmdir::rmdir ($folder);
  }


  public function store ($name, $book, $chapter, $verse, $html)
  {
    $file = $this->verseFile ($name, $book, $chapter, $verse);
    $folder = dirname ($file);
    if (!file_exists ($folder)) mkdir ($folder, 0777, true);
    file_put_contents ($file, $html);
  }


  public function exists ($name, $book, $chapter, $verse)
  {
    $file = $this->verseFile ($name, $book, $chapter, $verse);
    return file_exists ($file);
  }


  // Counts the number of verses in the offline resource $name.
  public function count ($name)
  {
    $count = 0;
    $resourceFolder = $this->resourceFolder ($name);
    @$books = scandir ($resourceFolder);
    if ($books) {
      $books = Filter_Folders::cleanup ($books);
      foreach ($books as $book) {
        $chapters = scandir ($this->bookFolder ($name, $book));
        $chapters = Filter_Folders::cleanup ($chapters);
        foreach ($chapters as $chapter) {
          $verses = scandir ($this->chapterFolder ($name, $book, $chapter));
          $verses = Filter_Folders::cleanup ($verses);
          $count += count ($verses);
        }
      }
    }
    return $count;
  }


  public function get ($name, $book, $chapter, $verse)
  {
    $file = $this->verseFile ($name, $book, $chapter, $verse);
    @$html = file_get_contents ($file);
    if ($html) return $html;
    return "";
  }


}


?>
