<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h1><?php echo gettext ("Installation") ?></h1>

<h2><?php echo gettext ("Standard installation") ?></h2>
<p><a href="installubuntu.php"><?php echo gettext ("Bibledit-Web 1.3 on Ubuntu 13.10.") ?></a></p>
<p><a href="installnewubuntu.php"><?php echo gettext ("Bibledit-Web 1.4 on Ubuntu 13.10.") ?></a></p>
<p><a href="installcentos.php"><?php echo gettext ("Bibledit-Web 1.4 on CentOS 6.4.") ?></a></p>
<p><a href="installlinuxhosting.php"><?php echo gettext ("Bibledit-Web 1.4 on shared Linux hosting.") ?></a></p>

<h2><?php echo gettext ("Several installations on one server") ?></h2>
<p>
  <?php echo gettext ("It is possible to have several installations of Bibledit-Web 1.3 on one server. ") ?>
</p>
<pre>./configure --with-location=location-one && make && sudo make install</pre>
<pre>./configure --with-location=biblename    && make && sudo make install</pre>
<pre>./configure --with-location=numberthree  && make && sudo make install</pre>
<p>
  <?php echo gettext ("This creates installations at the following URL's:") ?>
</p>
<ul>
<li>http://website.org/location-one</li>
<li>http://website.org/biblename</li>
<li>http://website.org/numberthree</li>
</ul>
<p>
  <?php echo gettext ("Everything is completely separated between the installation.") ?>
  <?php echo gettext ("This includes all data and the database.") ?>
  <?php echo gettext ("Every installation has its own independent database.") ?>
</p>
<p>
  <?php echo gettext ("The --with-location=location option does not take slashes.") ?>
  <?php echo gettext ("For example, --with-location=/location would fail.") ?>
  <?php echo gettext ("And --with-location=path/to/location would fail also.") ?>
</p>
<br>
<p>
  <?php echo gettext ("Parallel installations of Bibledit-Web 1.4 (not yet released) and higher can be created by unpacking the zip archive in sub folders with different names.") ?>
  <?php echo gettext ("When configuring Bibledit-Web, select different names for the databases also.") ?>
</p>

<h2><?php echo gettext ("Sword module repository") ?></h2>
<p>
  <?php echo gettext ("Bibledit-Web can export Bibles to a Sword module.") ?>
  <?php echo gettext ("It will store the module in a location accessible through the web server.") ?>
  <?php echo gettext ("You can also create a Sword module repository.") ?>
  <?php echo gettext ("This enables users to do an online installation of the Bible in their Sword front-end.") ?>
  <?php echo gettext ("To create a Sword module repository, install an anonymous FTP server, and set the root for anonymous access to the folder with exported Bibles.") ?>
</p>
<p><a href="ftpserver.php"><?php echo gettext ("Install FTP server on Ubuntu Server.") ?></a></p>

<h2><?php echo gettext ("Install development version") ?></h2>
<p>
  <?php echo gettext ("Read the instructions for a standard Bibledit-Web installation to find out about server setup and prerequisites.") ?>
</p>
<br>
<p>
  <?php echo gettext ("The Bibledit-Web code is kept in a git repository.") ?>
  <a href="https://savannah.nongnu.org/projects/bibledit-web" target="_blank"><?php echo gettext ("The repository is accessible from the Savannah Project Page.") ?></a>
  <?php echo gettext ("To view the code on the web, click Source Code - Browse Sources Repository.") ?>
  <?php echo gettext ("To use the repository in another way, click on Source Code - Use Git.") ?>
  <?php echo gettext ("Information will be provided there.") ?>
  <?php echo gettext ("The code can be checked out from the repository.") ?>
  <?php echo gettext ("This gives the most recent version of Bibledit-Web.") ?>
  <?php echo gettext ("The code is supported.") ?>
</p>
<br>
<p>
  <?php echo gettext ("To get the most recent code, run the following in a terminal:") ?>
</p>
<pre>$ git clone git://git.savannah.nongnu.org/bibledit-web</pre>
<p>
  <?php echo gettext ("This clones the code repository to your computer.") ?>
  <?php echo gettext ("It will create directory") ?>
  <code>bibledit-web</code>.
  <?php echo gettext ("Change into that directory.") ?>
  <?php echo gettext ("Then create an installation package:") ?>
</p>
<p><code>$ ./scripts/package</code></p>
<p>
  <?php echo gettext ("It will display where the package will be stored.") ?>
  <?php echo gettext ("This package can be used to do a standard installation of Bibledit-Web.") ?>
</p>

<h2><?php echo gettext ("Open installation") ?></h2>
<p><?php echo gettext ("You can configure the Bibledit-Web 1.3 installation to be completely open.") ?></p>
<pre>./configure --with-open-installation=true</pre>
<p>
  <?php echo gettext ("It means that there is no need to login to the website.") ?>
  <?php echo gettext ("The website appears to be logged in as user 'admin' for any visitor.") ?>
  <?php echo gettext ("This is useful for demo installations, or installations providing a free service to the the community.") ?>
  <?php echo gettext ("A disadvantage is that the crawlers of the search engines keep clicking links, and will disturb data and settings.") ?>
</p>
<br>
<p>
  <?php echo gettext ('For Bibledit-Web 1.4 (not yet released) and higher, open file <code>config/open.php</code> and set variable <code>$open_installation</code> to true.') ?>
</p>
