#============================================================================================================
#
#	VXef[^ǗW[
#
#============================================================================================================
package	MELKOR;

use strict;
#use warnings;
no warnings 'redefine';

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'SYS'	=> undef,
		'KEY'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	I0Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	
	# VXeݒǂݍ
	return $this->Load;
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeݒǂݍ
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	I0Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	
	# VXenbV̏
	my $pSys = $this->{'SYS'} = {};
	$this->{'KEY'} = [];
	InitSystemValue($this->{'SYS'}, $this->{'KEY'});
	my $sysFile = $this->{'SYS'}->{'SYSFILE'};
	
	# ݒt@Cǂݍ
	if (open(my $fh, '<', $sysFile)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			if ($_ =~ /^(.+?)<>(.*)$/) {
				$pSys->{$1} = $2;
			}
		}
	}
	
	# Ԑ̃`FbN
	my @dlist = localtime time;
	if (($dlist[2] >= $pSys->{'LINKST'} || $dlist[2] < $pSys->{'LINKED'}) &&
		($pSys->{'URLLINK'} eq 'FALSE')) {
		$pSys->{'LIMTIME'} = 1;
	}
	else {
		$pSys->{'LIMTIME'} = 0;
	}
	
	if ($this->Get('CONFVER', '') ne $pSys->{'VERSION'}) {
		$this->Save();
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeݒ菑
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	
	$this->NormalizeConf();
	
	my $path = $this->{'SYS'}->{'SYSFILE'};
	
	chmod($this->Get('PM-ADM'), $path);
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		foreach my $key (@{$this->{'KEY'}}) {
			my $val = $this->{'SYS'}->{$key};
			print $fh "$key<>$val\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	else {
		warn "can't save config: $path";
	}
	chmod($this->Get('PM-ADM'), $path);
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeݒl擾
#	-------------------------------------------------------------------------------------
#	@param	$key	擾L[
#			$default : ftHg
#	@return	ݒl
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	
	my $val = $this->{'SYS'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeݒlݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒL[
#	@param	$data	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{'SYS'}->{$key} = $data;
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeݒlr
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒL[
#	@param	$val	ݒl
#	@return	Ȃ^Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub Equal
{
	my $this = shift;
	my ($key, $data) = @_;
	
	return($this->{'SYS'}->{$key} eq $data);
}

#------------------------------------------------------------------------------------------------------------
#
#	IvVl擾- GetOption
#	-------------------------------------------
#	@F$flag : 擾tO
#	߂lF:IvVl
#			s:-1
#
#------------------------------------------------------------------------------------------------------------
sub GetOption
{
	my $this = shift;
	my ($flag) = @_;
	
	my @elem = split(/\,/, $this->{'SYS'}->{'OPTION'});
	
	return $elem[$flag - 1];
}

#------------------------------------------------------------------------------------------------------------
#
#	IvVlݒ - SetOption
#	-------------------------------------------
#	@F$last  : XgtO
#			$start : Jns
#			$end   : Is
#			$one   : >>1\tO
#			$alone : Pƕ\tO
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub SetOption
{
	my $this = shift;
	my ($last, $start, $end, $one, $alone) = @_;
	
	$this->{'SYS'}->{'OPTION'} = "$last,$start,$end,$one,$alone";
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeϐ - InitSystemValue
#	-------------------------------------------
#	@F$pSys : nbV̎Q
#			$pKey : z̎Q
#	߂lFȂ
#	@lF(*)}[NĂ鍀ڂ̂ݎ蓮ŕύX\ł
#
#------------------------------------------------------------------------------------------------------------
sub InitSystemValue
{
	my ($pSys, $pKey) = @_;
	
	my %sys = (
		'SYSFILE'	=> './info/system.cgi',						# VXeݒt@C
		'SERVER'	=> '',										# ݒuT[opX(*)
		'CGIPATH'	=> '/test',									# CGIݒupX(*)
		'INFO'		=> '/info',									# Ǘf[^ݒupX(*)
		'DATA'		=> '/datas',								# f[^ݒupX(*)
		'BBSPATH'	=> '..',									# fݒupX(*)
		'DEBUG'		=> 0,										# foO[h(*)
		'VERSION'	=> '0ch+ BBS 0.7.3 20130527',					# CGIo[W
		'PM-DAT'	=> 0644,									# datp[~V(*)
		'PM-TXT'	=> 0644,									# TXTp[~V(*)
		'PM-LOG'	=> 0600,									# LOGp[~V(*)
		'PM-ADM'	=> 0600,									# Ǘt@CQ(*)
		'PM-ADIR'	=> 0700,									# ǗDIRp[~V(*)
		'PM-BDIR'	=> 0711,									# DIRp[~V(*)
		'PM-LDIR'	=> 0700,									# ODIRp[~V(*)
		'PM-STOP'	=> 0444,									# XXgp[~V(*)
		'ERRMAX'	=> 500,										# G[Oőێ
		'SUBMAX'	=> 500,										# subjectőێ
		'RESMAX'	=> 1000,									# Xő发ݐ
		'ADMMAX'	=> 500,										# Ǘ샍Oőێ
		'HSTMAX'	=> 500,										# zXgOőێ
		'ANKERS'	=> 10,										# őAJ[
		'URLLINK'	=> 'TRUE',									# URLւ̎N
		'LINKST'	=> 23,										# N֎~Jn
		'LINKED'	=> 2,										# N֎~I
		'PATHKIND'	=> 0,										# pX̎
		'HEADTEXT'	=> '<small><b>fꗗ</b></small>',	# wb_̕\
		'HEADURL'	=> '../',									# wb_URL
		'FASTMODE'	=> 0,										# [h
		
		# 為vIWi
		'SAMBATM'	=> 0,										# ZԓeKb
		'DEFSAMBA'	=> 10,										# Sambaҋ@bftHgl
		'DEFHOUSHI'	=> 60,										# Sambad()ftHgl
		'BANNER'	=> 1,										# read.cgi̍m̕\
		'KAKIKO'	=> 1,										# 2dłHH
		'COUNTER'	=> '',										# ofuda.cc AJEg
		'PRTEXT'	=> '낿˂vX',					# PR̕\
		'PRLINK'	=> 'http://zerochplus.sourceforge.jp/',		# PR̃NURL
		'TRIP12'	=> 1,										# 12gbvϊ邩ǂ
		'MSEC'		=> 0,										# msec܂ŕ\邩
		'BBSGET'	=> 0,										# bbs.cgiGET\bhgp邩ǂ
		'CONFVER'	=> '',										# VXeݒt@C̃o[W
		'UPCHECK'	=> 1,										# XV`FbNԊu()
		
		# DNSBLݒ
		'BBQ'		=> 1,										# BBQ(niku.2ch.net)
		'BBX'		=> 0,										# BBX(bbx.2ch.net)
		
		'PERM_EXEC'		=> 0700,
		'PERM_DATA'		=> 0600,
		'PERM_CONTENT'	=> 0644,
		'PERM_SYSDIR'	=> 0700,
		'PERM_DIR'		=> 0711,
	);
	
	if ('Permission') {
		my $uid = (stat $ENV{'SCRIPT_FILENAME'})[4];
		if ($uid == 0) { # root / not linux
		} elsif ($uid == $<) { # suEXEC
		} else {
			$sys{'PM-DAT'} = 0666;
			$sys{'PM-TXT'} = 0666;
			$sys{'PM-LOG'} = 0666;
			$sys{'PM-ADM'} = 0666;
			$sys{'PM-ADIR'} = 0777;
			$sys{'PM-BDIR'} = 0777;
			$sys{'PM-LDIR'} = 0777;
			$sys{'PM-STOP'} = 0444;
		}
	}
	
	while (my ($key, $val) = each %sys) {
		$pSys->{$key} = $val;
	}
	
	# ێL[
	my @key = keys %sys;
	
	splice @$pKey, 0, scalar(@$pKey);
	push @$pKey, @key;
}

#------------------------------------------------------------------------------------------------------------
#
#	VXeϐK - NormalizeConf
#	-------------------------------------------
#	@F
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub NormalizeConf
{
	my $this = shift;
	my ($path, $buf, $perm, $server, $cgipath);
	
	if ($this->Get('SERVER', '') eq '') {
		my $path = $ENV{'SCRIPT_NAME'};
		$path =~ s|/[^/]+\.cgi([\/\?].*)?$||;
		$this->Set('SERVER', 'http://' . $ENV{'HTTP_HOST'});
		$this->Set('CGIPATH', $path);
	}
	
	if ('set CGI Path') {
		my $server = $this->Get('SERVER', '');
		my $cgipath = $this->Get('CGIPATH', '');
		if ($server =~ m|^(http://[^/]+)(/.+)$|) {
			$server = $1;
			$cgipath = "$2$cgipath";
		}
		$this->Set('SERVER', $server);
		$this->Set('CGIPATH', $cgipath);
	}
	
	$this->Set('CONFVER', $this->Get('VERSION'));
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
