#============================================================================================================
#
#	tH[ǗW[
#
#============================================================================================================
package	SAMWISE;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@F$throughget	GETNGXg̎󂯓
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	my ($throughget) = @_;
	
	my $form = '';
	if ($ENV{'REQUEST_METHOD'} eq 'POST') {
		read STDIN, $form, $ENV{'CONTENT_LENGTH'};
	}
	elsif ($throughget && defined $ENV{'QUERY_STRING'}) {
		$form = $ENV{'QUERY_STRING'};
	}
	
	my @SRC = split(/[&;]/, $form);
	
	my $obj = {
		'FORM'	=> undef,
		'SRC'	=> \@SRC,
	};
	
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[fR[h - DecodeForm
#	-------------------------------------------
#	@F$mode : 
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub DecodeForm
{
	my $this = shift;
	my ($mode) = @_;
	
	$this->{'FORM'} = {};
	
	foreach (@{$this->{'SRC'}}) {
		my ($var, $val) = split(/=/, $_, 2);
		$val =~ tr/+/ /;
		$val =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C', hex($1))/eg;
		$val =~ s/\r\n|\r|\n/\n/g;
		$val =~ s/\0//g;
		$this->{'FORM'}->{$var} = $val;
		$this->{'FORM'}->{"Raw_$var"} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[fR[h - GetAtArray
#	-------------------------------------------
#	@F$key : 擾L[
#			$f   : ϊtO
#	߂lFL[f[^̔z
#
#------------------------------------------------------------------------------------------------------------
sub GetAtArray
{
	my $this = shift;
	my ($key, $f) = @_;
	
	my @ret = ();
	
	foreach (@{$this->{'SRC'}}) {
		my ($var, $val) = split(/=/, $_, 2);
		if ($key eq $var) {
			$val =~ tr/+/ /;
			$val =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C', hex($1))/eg;
			$val =~ s/\r\n|\r|\n/\n/g;
			$val =~ s/\0//g;
			if ($f) {
				$val =~ s/"/&quot;/g;
				$val =~ s/</&lt;/g;
				$val =~ s/>/&gt;/g;
				$val =~ s/\r\n|\r|\n/<br>/g;
			}
			push @ret, $val;
		}
	}
	return @ret;
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[擾 - Get
#	-------------------------------------------
#	@F$key : 擾L[
#			$default : ftHg
#	߂lFf[^
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	
	my $val = $this->{'FORM'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : ''));
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[ݒ - Set
#	-------------------------------------------
#	@F$key  : 擾L[
#			$data : ݒf[^
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{'FORM'}->{$key} = $data;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$data	l
#	@return	lȂtrueԂ
#
#------------------------------------------------------------------------------------------------------------
sub Equal
{
	my $this = shift;
	my ($key, $data) = @_;
	
	my $val = $this->{'FORM'}->{$key};
	
	return (defined $val && $val eq $data);
}

#------------------------------------------------------------------------------------------------------------
#
#	̓`FbN - IsInput
#	-------------------------------------------
#	@F$pkeylist : 荀ڃXg(t@X)
#	߂lFOKȂ1,͂Ȃ0
#
#------------------------------------------------------------------------------------------------------------
sub IsInput
{
	my $this = shift;
	my ($pKeyList) = @_;
	
	foreach (@$pKeyList) {
		my $val = $this->{'FORM'}->{$_};
		if (!defined $val || $val eq '') {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	S̓`FbN - IsInput
#	-------------------------------------------
#	@FȂ
#	߂lFOKȂ1,͂Ȃ0
#
#------------------------------------------------------------------------------------------------------------
sub IsInputAll
{
	my $this = shift;
	
	foreach (values %{$this->{'FORM'}}) {
		if ($_ eq '') {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	L[݂true
#
#------------------------------------------------------------------------------------------------------------
sub IsExist
{
	my $this = shift;
	my ($key) = @_;
	
	return exists $this->{'FORM'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$string	
#	@return	݂1
#
#------------------------------------------------------------------------------------------------------------
sub Contain
{
	my $this = shift;
	my ($key, $string) = @_;
	
	if ($this->{'FORM'}->{$key} =~ /\Q$string\E/) {
		return 1;
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml擾
#	-------------------------------------------------------------------------------------
#	@param	$pArray	ʊi[obt@
#	@param	@list	擾f[^Xg
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetListData
{
	my $this = shift;
	my ($pArray, @list) = @_;
	
	foreach (@list) {
		push @$pArray, $this->{'FORM'}->{$_};
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	Ȃ1
#
#------------------------------------------------------------------------------------------------------------
sub IsNumber
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9]/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	pp
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsAlphabet
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z_@]/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	LbvL[p񒲍
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsCapKey
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z\_\.\+\-\*\/\@\:\!\%\&\(\)\=\~\^]/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	ffBNgp񒲍
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsBBSDir
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z\_\-]/) {
			return 0;
		}
	}
	return 1;
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
