/*

   Copyright 2001,2003  The Apache Software Foundation 

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package org.apache.batik.ext.awt.image.codec;

import java.util.MissingResourceException;

import org.apache.batik.i18n.LocalizableSupport;

public class PropertyUtil {
    protected final static String RESOURCES =
        "org.apache.batik.bridge.resources.properties";


    protected static LocalizableSupport localizableSupport =
        new LocalizableSupport
        (RESOURCES, PropertyUtil.class.getClassLoader());

    public static String getString(final String key) {
        try{
            return localizableSupport.formatMessage(key, null);
        }catch(final MissingResourceException e){
            return key;
        }
   }
}
