package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import map.data.City;


public class CityCsv {
	private static String dir = "./data/";
	
	public static void main(String[] args) throws IOException {
		CityCsv.read(new File(CityCsv.dir + "city.csv"));
	}
	public static void read(File file) throws IOException {
		BufferedReader in = null;
		BufferedWriter out = null;
		try {
			in = new BufferedReader(new FileReader(file));
			String line = null;
			int oldCode = 0;
			while ((line = in.readLine()) != null) {
				String[] param = line.split(",");
				int code = Integer.parseInt(param[1].substring(0, 2));
				if (code != oldCode) {
					oldCode = code;
					File outFile = new File(CityCsv.dir + City.prefectureFormat(code) + File.separatorChar + "city.csv");
					if (!outFile.getParentFile().isDirectory()) {
						outFile.getParentFile().mkdirs();
					}
					out = new BufferedWriter(new FileWriter(outFile));
				}
				out.write(line);
				out.newLine();
				out.flush();
			}
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}
}
