package map.route;
import map.data.Node;
/**
 * 直線距離を求めるためのクラス
 * @author ma38su
 */
public class DirectDistance implements HeuristicEstimate {
	/**
	 * Heuristic 距離を求める
	 * @param n1
	 * @param n2
	 * @return Heuristic 距離
	 */
	public double get(Node n1, Node n2) {
		long dx = n1.getX() - n2.getX();
		long dy = n1.getY() - n2.getY();
		return Math.sqrt(dx * dx + dy * dy);
	}
	@Override
	public String toString() {
		return "直線距離";
	}
}
