package map.data;

import java.io.Serializable;


/**
 * 曲線
 * 
 * @author ma38su
 */
public class Curve implements Serializable {

	/**
	 * X座標の配列
	 */
	final int[] x;

	/**
	 * Y座標の配列
	 */
	final int[] y;

	/**
	 * 鉄道種別
	 * type = 43 - 43 普通鉄道(JR)
	 *        44 - 43 普通鉄道
	 *        45 - 43 路面電車
	 *        46 - 43 地下式鉄道
	 *        47 - 43 その他
	 * 道路種別
	 * type = 16 - 13 高速道路
	 *        15 - 13 一般道
	 *        14 - 13 石段
	 *        13 - 13 庭園
	 */
	private final int type;

	/**
	 * 曲線
	 * @param curveX
	 * @param curveY
	 * @param type
	 */
	public Curve(int[] curveX, int[] curveY, int type) {
		this.x = curveX;
		this.y = curveY;
		this.type = type;
	}
	
	/**
	 * X座標の配列を取得
	 * @return X座標配列
	 */
	public int[] getArrayX() {
		return this.x;
	}
	/**
	 * Y座標の配列を取得
	 * @return Y座標配列
	 */
	public int[] getArrayY() {
		return this.y;
	}
	/**
	 * 鉄道種別
	 * type = 43 - 43 普通鉄道(JR)
	 *        44 - 43 普通鉄道
	 *        45 - 43 路面電車
	 *        46 - 43 地下式鉄道
	 *        47 - 43 その他
	 * 道路種別
	 * type = 16 高速道路
	 *        15 一般道
	 *        14 石段
	 *        13 庭園
	 * @return 各種別
	 */
	public int getType() {
		return this.type;
	}
}
