import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.WindowConstants;

/**
 * 地図をドット絵で描画するプログラムです。
 * @author Kumano Tatsuo
 * 2006/03/17
 */
public class Main {
	/**
	 * メインメソッドです。
	 * @param args
	 */
	public static void main(String[] args) {
		final Map<Point2D, String> stations = KSJ.loadStations();
		final Collection<Line2D> railways = KSJ.loadRailways();
		final MapPanel panel = new MapPanel(stations, railways);
		panel.setFocusable(true);
		final JFrame frame = new JFrame("DotMap");
		frame.setSize(800, 600);
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.add(panel);
		frame.setVisible(true);
	}
}
