package map.labeling;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.List;
import java.awt.Rectangle;
import java.util.ArrayList;
import map.data.Label;

/**
 * 単純なアルゴリズムのラベル配置
 * @author ma38su
 *
 */
public class SimpleLabeling implements Labeling {
	private final Graphics2D g;
	private final Rectangle screen0;
	private final Rectangle screen;
	private final float scale;
	private final FontMetrics metrics;
	private final int labelAscent;
	private final int labelHeight;
	private final List<Rectangle> lap;
	private final List<FixedLabel> label;
	public SimpleLabeling(final Graphics2D g, final Rectangle screen, final int width, final int height, final float scale) {
		this.scale = scale;
		this.g = g;
		this.screen0 = screen;
		this.screen = new Rectangle(0, 0, width, height);
		this.metrics = g.getFontMetrics();
		// ラベルの重なり
		this.lap = new ArrayList<Rectangle>();
		this.labelAscent = this.metrics.getAscent();
		this.labelHeight = this.metrics.getHeight();
		this.label = new ArrayList<FixedLabel>();
	}
	public void draw() {
		this.g.setColor(Color.BLACK);
		for (final FixedLabel label : this.label) {
			label.draw(this.g);
		}
	}
	public void add(Label[] data) {
		for (final Label label : data) {
		
			String name = label.getName();
	
			// 表示領域内のであれば描画する
			if (this.screen0.contains(label.getX(), label.getY())) {
				int x = (int) ((label.getX() - this.screen0.x) * this.scale);
				int y = this.screen.height - (int) ((label.getY() - this.screen0.y) * this.scale);
		
				int labelWidth = this.metrics.stringWidth(name);
	
				// 施設の位置を描画する
				boolean flag = false;

				Rectangle labelCandidate = null;

				for (int i = 0; i < 4; i++) {
					boolean isLap = false;
					labelCandidate = new Rectangle(x - (i / 2) * (labelWidth + 6) + 3, y - ((i % 2) * this.labelHeight), labelWidth, this.labelHeight);
					for (Rectangle rect : this.lap) {
						if (rect.intersects(labelCandidate)) {
							isLap = true;
							break;
						}
					}

					// 重なるか，スクリーン内からはみでる場合は再計算
					if (isLap || !this.screen.contains(labelCandidate)) {
						continue;
					}

					this.lap.add(labelCandidate);
					this.label.add(new FixedLabel(name, labelCandidate.x + 1, labelCandidate.y + this.labelAscent));
					flag = true;
					break;
				}
				if (flag) {
					this.g.setColor(Color.BLACK);
					this.g.fillOval(x - 2, y - 2, 4, 4);
				} else if (this.screen.contains(x, y)) {
					this.g.setColor(Color.GRAY);
					this.g.drawLine(x - 2, y - 2, x + 2, y + 2);
					this.g.drawLine(x + 2, y - 2, x - 2, y + 2);
				}
			}
		}
	}
}
