package map.ksj;

import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * 国土数値情報のデータ読み込むクラス
 * @author ma38su
 *
 */
public class KsjFactory {

	/**
	 * 地図情報からPolygonデータ読み込む
	 * @param stream
	 * @return 読み込んだPolygon配列を返す
	 * @throws IOException
	 */
	public static Polygon[] readPolygon(final InputStream stream) throws IOException {
		List<Polygon> list = new ArrayList<Polygon>();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(stream));
			String data;
			while ((data = in.readLine()) != null) {
				String[] param = data.split(",");
				int length = param.length / 2;
				int[] x = new int[length];
				int[] y = new int[length];	
				for (int i = 0; i < length; i++) {
					int index = i * 2;
					x[i] = Integer.parseInt(param[index]);
					y[i] = Integer.parseInt(param[index + 1]);
				}
				if((param.length % 2) != 0) {
					System.out.println("error KsjFactory : "+ param.length);
				}
				list.add(new Polygon(x, y, length));
			}
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return list.toArray(new Polygon[]{});
	}
}
