package car.map;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.TransformGroup;

/**
 * @author Kumano Tatsuo
 * Created on 2005/09/07
 */

public interface RoadMap {

	/**
	 * @return チェックポイントの一覧
	 */
	public abstract Line2D[] getCheckPoints();

	/**
	 * @return 縮尺
	 */
	public abstract float getZoom();

	/**
	 * @return ガードレールの一覧
	 */
	public abstract Line2D[] getBarriers();

	/**
	 * @return 情景
	 */
	public abstract BranchGroup getScene();

	/**
	 * @return 道路を平面に投影したもの
	 */
	public abstract Shape getRoadShape();

	/**
	 * @return 赤白の縁石の領域
	 */
	public abstract Shape[] getStripes();

	/**
	 * @return プレイヤ1の初期位置
	 */
	public abstract Point2D getInitialLocation1();

	/**
	 * @return プレイヤ2の初期位置
	 */
	public abstract Point2D getInitialLocation2();

	/**
	 * @return プレイヤの初期向き
	 */
	public abstract double getInitialDirection();

	/**
	 * @return コースマップ
	 */
	public abstract TransformGroup getCourseMap();
	
	/**
	 * @return 周回数
	 */
	public int getLap();

}