package car.character;

import java.io.FileNotFoundException;
import java.util.Enumeration;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;

import car.CarUtil;
import car.Player;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;

/**
 * 最高速度の速いプレイヤの個性です。
 * @author Kumano Tatsuo
 * Created on 2005/09/06
 */
public class MonkeyCharacter implements Character {

	/**
	 * エンジンブレーキによる減速
	 */
	private final double engineDecel;
	
	/**
	 * ブレーキによる減速
	 */
	private final double brakeDecel;
	/**
	 * コンストラクタです。
	 */
	public MonkeyCharacter() {
		final double accel = 0.04;
		final double speed = 6;
		final double handle = 0.012;
		this.fowardRoadAccel = accel;
		this.fowardDirtAccel = accel / 2;
		this.rearAccel = accel / 2;
		this.normalDecel = CarUtil.getDecel(speed, accel);
		this.handleDecel = 0.99;
		this.handleDecelThreshold = handle * 6;
		this.fowardRoadHandle = handle;
		this.fowardDirtHandle = handle / 4;
		this.rearHandle = handle / 2;
		this.normalHandleDecel = 0.9;
		this.slideDecel = 0.8;
		this.brakeDecel = 0.9;
		this.engineDecel = 0.97;
	}

	/**
	 * 舗装道の加速
	 */
	private final double fowardRoadAccel;

	/**
	 * 悪路の加速
	 */
	private final double fowardDirtAccel;

	/**
	 * 後進時の加速
	 */
	private final double rearAccel;

	/**
	 * 空気抵抗
	 */
	private final double normalDecel;

	/**
	 * ハンドルを切ったときの減速
	 */
	private final double handleDecel;

	/**
	 * 減速するハンドルの切れ角
	 */
	private final double handleDecelThreshold;

	/**
	 * 舗装道のハンドル
	 */
	private final double fowardRoadHandle;

	/**
	 * 悪路のハンドル
	 */
	private final double fowardDirtHandle;

	/**
	 * 後進時のハンドル
	 */
	private final double rearHandle;

	/**
	 * ハンドルの戻る速さ
	 */
	private final double normalHandleDecel;

	/**
	 * 平行移動の減速
	 */
	private final double slideDecel;


	public double getFowardDirtAccel() {
		return this.fowardDirtAccel;
	}


	public double getFowardDirtHandle() {
		return this.fowardDirtHandle;
	}


	public double getFowardRoadAccel() {
		return this.fowardRoadAccel;
	}


	public double getFowardRoadHandle() {
		return this.fowardRoadHandle;
	}


	public double getHandleDecel() {
		return this.handleDecel;
	}


	public double getHandleDecelThreshold() {
		return this.handleDecelThreshold;
	}


	public double getNormalDecel() {
		return this.normalDecel;
	}


	public double getNormalHandleDecel() {
		return this.normalHandleDecel;
	}


	public double getRearAccel() {
		return this.rearAccel;
	}


	public double getRearHandle() {
		return this.rearHandle;
	}


	public double getSlideDecel() {
		return this.slideDecel;
	}


	public TransformGroup getCarTransformGroup(Player player,
			Color3f bodyColor, Color3f rubberColor, Color3f personColor, Color3f headColor) {
		final TransformGroup ret = new TransformGroup();
		ret.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		try {
			final Appearance bodyAppearance = new Appearance();
			final Material bodyMaterial = new Material();
			bodyMaterial.setDiffuseColor(bodyColor);
			bodyAppearance.setMaterial(bodyMaterial);
			final Appearance rubberAppearance = new Appearance();
			final Material rubberMaterical = new Material();
			rubberMaterical.setDiffuseColor(rubberColor);
			rubberAppearance.setMaterial(rubberMaterical);
			final Appearance personAppearance = new Appearance();
			final Material personMaterical = new Material();
			personMaterical.setDiffuseColor(personColor);
			personAppearance.setMaterial(personMaterical);
			final Appearance headAppearance = new Appearance();
			final Material headMaterical = new Material();
			headMaterical.setDiffuseColor(headColor);
			headAppearance.setMaterial(headMaterical);
			final Transform3D transform = new Transform3D();
			transform.rotX(-Math.PI / 2);
			final Transform3D rotZTransform = new Transform3D();
			rotZTransform.rotZ(Math.PI);
			transform.mul(rotZTransform);
			final TransformGroup transformGroup = new TransformGroup(transform);
			final Loader loader = new ObjectFile();
			final Scene scene = loader.load(MonkeyCharacter.class.getResource("10.obj"));
			final BranchGroup sceneGroup = scene.getSceneGroup();
			final Enumeration enumeration = sceneGroup.getAllChildren();
			int count = 0;
			while (enumeration.hasMoreElements()) {
				final Object o = enumeration.nextElement();
			    if (o instanceof Shape3D){
			    	final Shape3D shape = (Shape3D) o;
			    	switch (count) {
			    	case 0: // タイヤ、椅子、ハンドル
			    		shape.setAppearance(rubberAppearance);
			    		break;
			    	case 1: // 車体
			    		shape.setAppearance(bodyAppearance);
			    		break;
			    	case 2: // 頭
			    		shape.setAppearance(headAppearance);
			    		break;
			    	case 3: // 服
			    		shape.setAppearance(personAppearance);
			    		break;
			    	}
			    }
			    count++;
			}
			transformGroup.addChild(sceneGroup);
			ret.addChild(transformGroup);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IncorrectFormatException e) {
			e.printStackTrace();
		} catch (ParsingErrorException e) {
			e.printStackTrace();
		}
		return ret;
	}


	public double getWidth() {
		return 1.2;
	}


	public double getLength() {
		return 1.8;
	}


	public double getHeight() {
		return 0.8;
	}

	public double getEngineDecel() {
		return this.engineDecel;
	}


	public double getBrakeDecel() {
		return this.brakeDecel;
	}


	public double getDriftThreshold() {
		return 0.2;
	}


	public double getDriftAmount() {
		return 10;
	}


}
