package car;

import java.awt.event.KeyEvent;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/09/09
 */
public class Const {
	/**
	 * キー操作に関する定数
	 */
	static class Key {
		/**
		 * プレイヤ1のアクセル
		 */
		public static final int PLAYER1_ACCEL = KeyEvent.VK_BACK_SLASH;

		/**
		 * プレイヤ1のブレーキ
		 */
		public static final int PLAYER1_BRAKE = KeyEvent.VK_SLASH;

		/**
		 * プレイヤ1のアイテム
		 */
		public static final int PLAYER1_ITEM = KeyEvent.VK_COLON;

		/**
		 * プレイヤ1の左ハンドル
		 */
		public static final int PLAYER1_LEFT = KeyEvent.VK_LEFT;

		/**
		 * プレイヤ1の右ハンドル
		 */
		public static final int PLAYER1_RIGHT = KeyEvent.VK_RIGHT;

		/**
		 * プレイヤ2のアクセル
		 */
		public static final int PLAYER2_ACCEL = KeyEvent.VK_X;

		/**
		 * プレイヤ2のブレーキ
		 */
		public static final int PLAYER2_BRAKE = KeyEvent.VK_Z;

		/**
		 * プレイヤ2のアイテム
		 */
		public static final int PLAYER2_ITEM = KeyEvent.VK_S;

		/**
		 * プレイヤ2の左ハンドル
		 */
		public static final int PLAYER2_LEFT = KeyEvent.VK_V;

		/**
		 * プレイヤ2の右ハンドル
		 */
		public static final int PLAYER2_RIGHT = KeyEvent.VK_B;

	}

	/**
	 * 周回に関する定数
	 */
	static class Lap {
		/**
		 * 最終周回
		 */
		public static final int FINAL_LAP = 4;

		/**
		 * 完走
		 */
		public static final int FINISHED = 5;

		/**
		 * 出発
		 */
		public static final int GO = 10;

		/**
		 * アクセルを押すよう促すメッセージ
		 */
		public static final int PRESS_ACCEL = 6;

		/**
		 * 準備
		 */
		public static final int READY = 9;

		/**
		 * キャラクタ選択
		 */
		public static final int SELECT_CHARACTER = 7;

		/**
		 * コース選択
		 */
		public static final int SELECT_COURSE = 8;

		/**
		 * 逆走
		 */
		public static final int WRONG_WAY = 11;
		
		/**
		 * 非表示
		 */
		public static final int HIDE = -1;
	}

	/**
	 * ゲームの状態
	 */
	public enum Status {
		/**
		 * ゲーム終了
		 */
		GAME_OVER,
		/**
		 * ゲーム中
		 */
		PLAYING,
		/**
		 * コース選択画面
		 */
		SELECT_COURSE,
		/**
		 * プレイヤ選択画面
		 */
		SELECT_CHARACTER,
		/**
		 * タイトル画面
		 */
		TITLE
	}

}
