import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

import car.Const;
import car.Game;
import car.KeyHandler;
import car.MainLoop;
import car.Player;
import car.PlayerPanel;
import car.character.Character;
import car.character.RocketCharacter;
import car.character.MonkeyCharacter;
import car.character.TortoiceCharacter;
import car.map.DreamRoadMap;
import car.map.KartRoadMap;
import car.map.KinokoRoadMap;
import car.map.KitakobeRoadMap;
import car.map.KyokuyoRoadMap;
import car.map.RoadMap;
import car.map.ShibaharaRoadMap;
import car.map.TsukubaRoadMap;
import car.map.TsukubaRoadMap2;

/**
 * カートレースゲームです。
 * @author Kumano Tatsuo
 * http://download.java.net/media/java3d/javadoc/1.3.2/
 * 2005/09/30 060
 * - 遅い車を少し速くしました。
 * - ドリフト中にカメラがカーブの内側を見るようにしました。一時的にちらつき防止を外しています。
 * - 徐々にドリフトするようにしました。
 * - ドリフトの量を増やしました。
 * - 遅い車をやめました。
 * - ドリフト中もカメラがプレイヤの進行方向を向くようにカメラの位置を移動しました。
 * - ちらつき防止を有効にしました。
 * - ゲーム開始時にハンドルをリセットするようにしました。
 * - 速いパソコンで「go!」が表示されない不具合を修正しました。
 * - ステージと車をサブパッケージにまとめました。
 * - 加速が良くて空を飛んでいる車を作りました。
 * 2005/09/29 059
 * - 曲陽公園サーキットのステージを修正しました。
 * - 三角コーンをコーナーの内側のみに置くようにしました。
 * - 良く曲がる車を遅くした車を作りました。
 * 2005/09/27 058
 * - 北神戸サーキットのステージを作ってみました。
 * - メインループを1回実行する時間が一定になるように待ち時間を調整するようにしました。
 * - 「finished」というメッセージが一瞬表示されていた不具合を修正しました。
 * - ドリームサーキットのステージを作ってみました。
 * 2005/09/26 057
 * - ステージを一度に読み込まないようにしました。少し軽くなりました。
 * - 軽くするために、遠くにあるものが表示されないようにしました。
 * 2005/09/24 056
 * - えびすサーキットのステージを作ってみましたが、全く面白くありませんでした。
 * - 芝原ツインサーキットのステージを作ってみました。
 * - ドリフトで壁に衝突したときに跳ね返されない不具合を修正しました。
 * 2005/09/24 055
 * - 横方向の力が閾値を越えると横滑りするようにしました。操作が難しくなりました。
 * 2005/09/23 054
 * - 曲陽公園サーキットのステージを作ってみました。
 * - 壁との反発を激しくしました。
 * 2005/09/23 053
 * - チェックポイントを表示してみました。
 * - チェックポイントを修正しました。
 * 2005/09/23 052
 * - 最高速度の速い車のグラフィックをメタセコイアで作りました。
 * - 車種を選ぶ画面のメッセージを「select a car」に変えました。
 * - 壁に平行にめり込んだときに動けなくなる不具合を修正しました。
 * - 車の幅と長さを調整しました。
 * 2005/09/22 051
 * - メタセコイアで作った車のグラフィックを読み込んで、良く曲がるキャラクタに割り当てました。
 * - 車の設定を変えました。
 * 2005/09/16 050
 * - アクセルを離したときに、空気抵抗だけでなくエンジンブレーキもかかるようにしました。
 * - ブレーキを踏んだときに、後ろ方向の加速度を加算するのでなく、ブレーキがかかるようにしました。
 * - 壁にぶつかったときの反応を043のときのものに戻しました。
 * - 止まっているときは曲がれないようにしました。
 * - 筑波サーキットのコース1000で、照明を暗くしました。
 * 2005/09/16 049
 * - 周回に関するメッセージを定数にまとめました。
 * - コースによって周回数を変えました。
 * - どちらかがゴールしたときにゲームを終わるようにしました。
 * - タイトル画面とゲーム終了時に、両方のプレイヤがアクセルを押さないとキャラクタ選択画面に移行しないようにしました。
 * - コース選択画面で、コースを選択しなかったプレイヤがアクセルを押すとゲームが始まるようにしました。
 * - ブレーキでキャラクタ選択とコース選択を取り消せるようにしました。
 * - ゲーム開始時に速度を初期化するようにしました。
 * - カメラを傾けるのをやめました。
 * - 筑波サーキットのコース1000を作ってみました。
 * 2005/09/13 048
 * - 車の設定を変えました。
 * 2005/09/09 047
 * - タイトル画面とキャラクタ選択画面ではコースマップとスピードメータが表示されないようにしました。
 * - タイトル画面を作りました。
 * - タイトルバーに表示される文字列をKartにしました。
 * - ノコノコの加速を悪くしました。
 * 2005/09/09 046
 * - メインループがゲームの状態を保持するようにしました。
 * - キーを変えました。
 * - 相反するキーを両方押したときは、両方離したときと同じ扱いにしました。
 * - メインループを複数のメソッドに分けました。
 * - プレイヤとコースを選べるようになりました。
 * - カメラが位置と目標地点とその速度を持つようにしました。
 * - コース選択の画面でカメラがコース上を走るようになりました。
 * - まともに対戦できるようになりました！
 * 2005/09/09 045
 * - 名称をCarからKartに変えました。
 * - Switchを使って動的にコースとプレイヤのグラフィックを変えられるようにしました。
 * 2005/09/09 044
 * - プレイヤの向きの基準を変えました。
 * - 衝突のときの挙動を改善しました。
 * - Escキーで終了するようにしました。
 * 2005/09/07 043
 * - HUDにコースマップを表示してみました。
 * - コースマップにプレイヤの所在地を表示しました。
 * - ステージのインターフェイスを作りました。
 * - HUDに順位を表示しました。
 * - HUDに速度計の針を表示しました。
 * - ノコノコが、カーブのときに減速しないようにしました。
 * - ドンキーの設定を変えました。
 * - HUDに周回を表示しました。
 * 2005/09/07 042
 * - Switchを使うことで、タイム表示を高速化しました。
 * 2005/09/06 041
 * - HUD（Head Up Display）にタイムを表示してみましたが、重すぎてやってられません。
 * 2005/09/06 040
 * - 筑波サーキットのデータを格納するファイルとクラス名を変えました。
 * - プレイヤの初期配置をステージデータから読み込むようにしました。
 * - ステージエディタを配布物から除きました。
 * - マリオサーキット1のステージを作りました。
 * - 悪路で走りにくくしました。
 * 2005/09/06 039
 * - ゴールが細くなっていたバグを直しました。
 * - ノコノコのハンドルを切れやすくしました。
 * - プレイヤの個性を表すインターフェイスと実装を作りました。
 * - プレイヤの幅、長さ、高さを個性に持たせました。
 * - ノコノコとドンキーの特性とグラフィックを作りました。
 * 2005/09/04 038
 * - 道路の両端に白線を引きました。
 * - ゴールラインを4角形ではなく、直線にしました。
 * - ゴールラインのテクスチャを回転させました。
 * 2005/09/03 037
 * - プレイヤに加速度や最高速度などの情報を持たせました。
 * - 試しに、1Pをノコノコに、2Pをドンキーにしてみました。
 * - コマンドラインからノコノコ、ヨッシー、ドンキーを選べるようにしてみました。
 * 2005/09/02 036
 * - テクスチャをリソースから読み込むようにしました。
 * - 固定したオブジェクトを置いてみました。
 * - 自車を固定オブジェクトにすることで、チラつかないようにしました。やったー、うまく行った！
 * 2005/09/02 035
 * - プレイヤ同士の当たり判定をしてみました。
 * - プレイヤ同士が当たったときに跳ね返るようにしました。
 * - 壁に当たったときに、滑らかに跳ね返るようになりました。
 * 2005/09/01 034
 * - 線分から領域を作ってみました。
 * - 赤白の縁石ができました！縁石との当たり判定はまだです。
 * - ハンドルを切ったときの減速を調整しました。
 * - 後進のときにもカーブの内側を向くようにしました。
 * - 道路上にいないときのみ壁との当たり判定をするようにしました。
 * - 縁石との当たり判定をするようにしました。
 * - 縁石と道路の色を変えました。
 * - toLinesメソッドをCarUtilに移動しました。
 * - ステージの情報をJavaソースとして保存するようにしました。
 * - ステージのデータファイルを読み込まずにゲームができるようになりました。
 * 2005/08/30 033
 * - ステージエディタで、パスを閉じないようにできるようにしました。
 * - ステージエディタで、点の大きさを設定できるようにしました。
 * - 赤白の縁石を作ろうとしましたが、うまくいきません。
 * 2005/08/28 032
 * - ステージエディタの続きです。
 * - ステージエディタがファイルを持つようにしました。
 * - ステージエディタで作った池を読み込んでみました。
 * - ステージエディタで作った道路を読み込んでみました。
 * - ステージエディタで作ったゴールラインを読み込んでみました。
 * - ステージエディタで作ったチェックポイントを読み込めるようになりました。
 * - ハンドルの切れ具合を調整しました。
 * - 逆走を検出できるようにしました。
 * - ドリフトを激しくしました。
 * - 後輪を大きくしてみました。
 * - ハンドルから手を離したときにすぐにハンドルが中央に戻るようにしました。
 * 2005/08/28 031
 * - 再編集可能なステージエディタを作り始めました。
 * - 複数の閉領域を編集できるようになりました。
 * 2005/08/27 030
 * - カメラとプレイヤとの距離を一定にしてみました。
 * - プレイヤの向きを進行方向よりも内側に向けました。
 * - 車の形を整えました。
 * - ゴールに線を引きました。
 * - チェックポイントを作りました。
 * - 周回判定ができるようになりました。
 * - 1周にかかった時間を表示してみました。
 * 2005/08/27 029
 * - Windowsでプレイヤ１がカクカクするのを直そうとしています。
 * - 2枚目のPlayerPanelを先に更新するとカクカクしなくなりました。なんでやろ？
 * - ハンドルが一瞬で戻っていた不具合を修正しました。
 * - カメラのモデルを2次元にして可視化してみました。
 * - カメラの動きに加速度を使ってみましたが、酔います。
 * 2005/08/25 028
 * - ハンドルが徐々に切れるようにしました。
 * - 遅いときに止まるようにしました。
 * 2005/08/25 027
 * - マウスクリックで座標を取得できるようにしました。
 * - 裏向きのポリゴンが描画できないので、どちら側からでも見えるようにしました。
 * - 池を作ってみました。
 * - ガードレールを繋げました。
 * - 筑波サーキットのステージが大体完成しました。
 * - カメラの位置と見る方向を変えました。
 * 2005/08/24 026
 * - マップの情報をRoadMapクラスに持たせてみました。
 * - プレイヤがどこにいるかを調べてみました。
 * - 遅いときに止まるのをやめました。
 * - 道路以外を走ると、加速とハンドルの効きが悪くなるようにしてみました。
 * - いろいろ許可を消しました。
 * - Java3Dの機能で車とガードレールとの当たり判定をしようとしましたが、あきらめました。
 * - 2点を指定してガードレールを設置できるようにしました。
 * - コースの内側にもガードレールを設定してみました。
 * - 車とガードレールとの当たり判定をしてみました。
 * - 照明を4つにしてみました。
 * - プレイヤに車幅と車長と車高を持たせました。
 * - ガードレールに当たったときに車の向きが変わるようにしました。
 * - ガードレールに当たったときに車が内側に移動するようにしました。ガードレールの左側を内側としています。
 * - ガードレールに当たったときに車が止まるようにしました。
 * - ステージを作りやすくしました。
 * - 筑波サーキットのステージを作り始めました。
 * 2005/08/23 025
 * - MainFrameが何もしていなかったので削除しました。
 * - ガードレールを作ってみました。
 * - 赤と白の縞を作ってみました。
 * 2005/08/23 024
 * - カメラの位置を変えました。
 * - ライトの設定を変えました。
 * - キーが離されたときにすぐfalseにするのではなく、次にキーが取得されてからfalseにすることにより、自車の動きを滑らかにしました。
 * - よく分からなくなってきたので、2人プレイ専用にしました。
 * - まともに2人で車を動かせるようになりました。
 * 2005/08/23 023
 * - バージョン番号を整数にしました。
 * - 画像をディレクトリに移動しました。
 * - 地図を読み込むのをやめました。
 * - いろいろfinalをつけました。
 * - 照明を変えました。
 * - カメラの追随を速くしました。
 * - オーバルコースを作ってみました。
 * - 止まっているときにもハンドルを切られるようにしました。
 * - キーの扱いを変えました。
 * - パネルを2枚表示してみました。
 * - プレイヤをもう1人用意しました。
 * - 設計が悪かったので相手のプレイヤが見えません。
 * 2005/08/22 022
 * - 更新履歴の書き方を変えました。
 * - 鈴鹿サーキットのコースガイドをダウンロードしました。
 * - 筑波サーキットのコースガイドをダウンロードしました。
 * - MINEサーキットのコースガイドをダウンロードしました。
 * - 芝原ツインサーキットのコースガイドをダウンロードしました。
 * 2005/08/21 021 文字化けしたのでフォントを変えました。
 * 2004/12/18 020 y座標を反転させました。
 * 2004/12/18 019 建物のデータを読み込んでみました。
 * 2004/12/17 018 文字を描画してみました。
 * 2004/12/17 017 フレームレートを落としました。
 * 2004/12/12 016 道路でない部分を緑色にしました。
 * 2004/12/12 015 ハンドルを切ったときに速度が落ちるようにしました。
 * 2004/12/12 014 後進しているときに、カメラが車の後方を見るようにしました。
 * 2004/12/12 013 道路が正しく描画されない不具合を修正しました。
 * 2004/12/12 012 道路の種類によって太さを変えました。
 * 2004/12/12 011 道路を面で表示しました。
 * 2004/12/12 010 道路を線で表示しました。
 * 2004/12/12 009 地図を読み込んでみました。
 * 2004/12/12 008 パッケージ管理するようにしました。
 * 2004/12/12 007 自車が加速するようにしました。 
 * 2004/12/12 006 座標のスケールを実在の大きさにしました。 
 * 2004/12/12 005 曲がっているときに、カメラが傾くようにしました。 
 * 2004/12/12 004 カメラが自車を追尾するようにしました。 
 * 2004/12/12 003 自車を動かせるようにしました。 
 * 2004/12/12 002 変数名を分かりやすくしました。 
 * 2004/12/11 001 初版です。
 */
public class Main {
	/**
	 * メインメソッドです。
	 * @param args コマンドライン引数
	 */
	public static void main(final String[] args) {
		final RoadMap[] maps = new RoadMap[] { new KartRoadMap(), new TsukubaRoadMap(),
				new TsukubaRoadMap2(), new KyokuyoRoadMap(), new ShibaharaRoadMap(),
				new KitakobeRoadMap(), new DreamRoadMap(), new KinokoRoadMap() };
		final Character[] characters = new Character[] { new TortoiceCharacter(),
				new MonkeyCharacter(), new RocketCharacter() };
		final Player player1 = new Player();
		final Player player2 = new Player();
		final RoadMap map = maps[0];
		final Game game = new Game();
		game.setStatus(Const.Status.TITLE);
		player1.setX(map.getInitialLocation1().getX());
		player1.setY(map.getInitialLocation1().getY());
		player1.setDirection(map.getInitialDirection());
		player2.setX(map.getInitialLocation2().getX());
		player2.setY(map.getInitialLocation2().getY());
		player2.setDirection(map.getInitialDirection());
		player1.setCharacter(characters[0]);
		player2.setCharacter(characters[0]);
		final KeyHandler handler = new KeyHandler();
		final PlayerPanel panel1 = new PlayerPanel(player1, player2, true, handler, maps,
				characters, game);
		final PlayerPanel panel2 = new PlayerPanel(player1, player2, false, handler, maps,
				characters, game);
		final JFrame frame = new JFrame();
		frame.setTitle("Kart");
		frame.setSize(new Dimension(640, 480));
		frame.setLocationByPlatform(true);
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setLayout(new GridLayout(2, 2));
		frame.add(panel1);
		frame.add(panel2);
		final MainLoop mainLoop = new MainLoop(player1, player2, panel1, panel2, maps, handler,
				characters, game);
		panel1.switchMap(0);
		panel2.switchMap(0);
		panel1.switchCharacter(0);
		panel1.switchCharacter2(0);
		panel2.switchCharacter(0);
		panel2.switchCharacter2(0);
		mainLoop.switchMap(0);
		mainLoop.start();
		frame.setVisible(true);
	}
}
