package sound;

import java.applet.AudioClip;
import java.util.Random;

/**
 * 効果音を管理するクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/09 17:40:32
 */
public class SE {
    /**
     * 泡が固定したときの音を鳴らします。
     */
    public static void put() {
        Const.SE_PUT.play();
    }
    
    /**
     * 泡が消えたときの音を鳴らします。
     */
    public static void remove() {
        Const.SE_REMOVE.play();
    }

    /**
     * 連鎖したときの音を鳴らします。
     */
    public static void chain() {
        Const.SE_CHAIN[new Random().nextInt(Const.SE_CHAIN.length)].play();
    }

    /**
     * おじゃまが降ったときの音を鳴らします。
     */
    public static void jam() {
        Const.SE_JAM[new Random().nextInt(Const.SE_JAM.length)].play();
    }
    
    /**
     * 全ての音を鳴らします。
     */
    public static void preLoad() {
        try {
            put();
            Thread.sleep(200);
            remove();
            for(AudioClip clip : Const.SE_CHAIN){
                Thread.sleep(200);
                clip.play();
            }
            for(AudioClip clip : Const.SE_JAM){
                Thread.sleep(200);
                clip.play();
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
